/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.auth;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.util.ByteBufferUtil;
import com.hivemq.client.mqtt.datatypes.MqttUtf8String;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5SimpleAuth;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class MqttSimpleAuth
implements Mqtt5SimpleAuth {
    @Nullable
    private final MqttUtf8StringImpl username;
    @Nullable
    private final ByteBuffer password;

    public MqttSimpleAuth(@Nullable MqttUtf8StringImpl username, @Nullable ByteBuffer password) {
        this.username = username;
        this.password = password;
    }

    @Override
    @NotNull
    public Optional<MqttUtf8String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    @Nullable
    public MqttUtf8StringImpl getRawUsername() {
        return this.username;
    }

    @Override
    @NotNull
    public Optional<ByteBuffer> getPassword() {
        return ByteBufferUtil.optionalReadOnly(this.password);
    }

    @Nullable
    public ByteBuffer getRawPassword() {
        return this.password;
    }

    @NotNull
    private String toAttributeString() {
        return this.username == null ? (this.password == null ? "" : "password") : (this.password == null ? "username" : "username and password");
    }

    @NotNull
    public String toString() {
        return "MqttSimpleAuth{" + this.toAttributeString() + '}';
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MqttSimpleAuth)) {
            return false;
        }
        MqttSimpleAuth that = (MqttSimpleAuth)o;
        return Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.username);
        result = 31 * result + Objects.hashCode(this.password);
        return result;
    }
}

