/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.connect.connack;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.mqtt.datatypes.MqttClientIdentifierImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.message.MqttMessageWithUserProperties;
import com.hivemq.client.internal.mqtt.message.connect.connack.MqttConnAckRestrictions;
import com.hivemq.client.internal.util.StringUtil;
import com.hivemq.client.mqtt.datatypes.MqttClientIdentifier;
import com.hivemq.client.mqtt.datatypes.MqttUtf8String;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5EnhancedAuth;
import com.hivemq.client.mqtt.mqtt5.message.connect.connack.Mqtt5ConnAck;
import com.hivemq.client.mqtt.mqtt5.message.connect.connack.Mqtt5ConnAckReasonCode;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;

@Immutable
public class MqttConnAck
extends MqttMessageWithUserProperties.WithReason.WithCode<Mqtt5ConnAckReasonCode>
implements Mqtt5ConnAck {
    public static final long SESSION_EXPIRY_INTERVAL_FROM_CONNECT = -1L;
    public static final int KEEP_ALIVE_FROM_CONNECT = -1;
    private final boolean sessionPresent;
    private final long sessionExpiryInterval;
    private final int serverKeepAlive;
    @Nullable
    private final MqttClientIdentifierImpl assignedClientIdentifier;
    @Nullable
    private final Mqtt5EnhancedAuth enhancedAuth;
    @NotNull
    private final MqttConnAckRestrictions restrictions;
    @Nullable
    private final MqttUtf8StringImpl responseInformation;
    @Nullable
    private final MqttUtf8StringImpl serverReference;

    public MqttConnAck(@NotNull Mqtt5ConnAckReasonCode reasonCode, boolean sessionPresent, long sessionExpiryInterval, int serverKeepAlive, @Nullable MqttClientIdentifierImpl assignedClientIdentifier, @Nullable Mqtt5EnhancedAuth enhancedAuth, @NotNull MqttConnAckRestrictions restrictions, @Nullable MqttUtf8StringImpl responseInformation, @Nullable MqttUtf8StringImpl serverReference, @Nullable MqttUtf8StringImpl reasonString, @NotNull MqttUserPropertiesImpl userProperties) {
        super(reasonCode, reasonString, userProperties);
        this.sessionPresent = sessionPresent;
        this.sessionExpiryInterval = sessionExpiryInterval;
        this.serverKeepAlive = serverKeepAlive;
        this.assignedClientIdentifier = assignedClientIdentifier;
        this.enhancedAuth = enhancedAuth;
        this.restrictions = restrictions;
        this.responseInformation = responseInformation;
        this.serverReference = serverReference;
    }

    @Override
    public boolean isSessionPresent() {
        return this.sessionPresent;
    }

    @Override
    @NotNull
    public OptionalLong getSessionExpiryInterval() {
        return this.sessionExpiryInterval == -1L ? OptionalLong.empty() : OptionalLong.of(this.sessionExpiryInterval);
    }

    public long getRawSessionExpiryInterval() {
        return this.sessionExpiryInterval;
    }

    @Override
    @NotNull
    public OptionalInt getServerKeepAlive() {
        return this.serverKeepAlive == -1 ? OptionalInt.empty() : OptionalInt.of(this.serverKeepAlive);
    }

    public int getRawServerKeepAlive() {
        return this.serverKeepAlive;
    }

    @Override
    @NotNull
    public Optional<MqttClientIdentifier> getAssignedClientIdentifier() {
        return Optional.ofNullable(this.assignedClientIdentifier);
    }

    @Nullable
    public MqttClientIdentifierImpl getRawAssignedClientIdentifier() {
        return this.assignedClientIdentifier;
    }

    @Override
    @NotNull
    public Optional<Mqtt5EnhancedAuth> getEnhancedAuth() {
        return Optional.ofNullable(this.enhancedAuth);
    }

    @Nullable
    public Mqtt5EnhancedAuth getRawEnhancedAuth() {
        return this.enhancedAuth;
    }

    @Override
    @NotNull
    public MqttConnAckRestrictions getRestrictions() {
        return this.restrictions;
    }

    @Override
    @NotNull
    public Optional<MqttUtf8String> getResponseInformation() {
        return Optional.ofNullable(this.responseInformation);
    }

    @Override
    @NotNull
    public Optional<MqttUtf8String> getServerReference() {
        return Optional.ofNullable(this.serverReference);
    }

    @Override
    @NotNull
    protected String toAttributeString() {
        return "reasonCode=" + this.getReasonCode() + ", sessionPresent=" + this.sessionPresent + (this.sessionExpiryInterval == -1L ? "" : ", sessionExpiryInterval=" + this.sessionExpiryInterval) + ((long)this.serverKeepAlive == -1L ? "" : ", serverKeepAlive=" + this.serverKeepAlive) + (this.assignedClientIdentifier == null ? "" : ", assignedClientIdentifier=" + this.assignedClientIdentifier) + (this.enhancedAuth == null ? "" : ", enhancedAuth=" + this.enhancedAuth) + (this.restrictions == MqttConnAckRestrictions.DEFAULT ? "" : ", restrictions=" + this.restrictions) + (this.responseInformation == null ? "" : ", responseInformation=" + this.responseInformation) + (this.serverReference == null ? "" : ", serverReference=" + this.serverReference) + StringUtil.prepend(", ", super.toAttributeString());
    }

    @NotNull
    public String toString() {
        return "MqttConnAck{" + this.toAttributeString() + '}';
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MqttConnAck)) {
            return false;
        }
        MqttConnAck that = (MqttConnAck)o;
        return this.partialEquals(that) && this.sessionPresent == that.sessionPresent && this.sessionExpiryInterval == that.sessionExpiryInterval && this.serverKeepAlive == that.serverKeepAlive && Objects.equals(this.assignedClientIdentifier, that.assignedClientIdentifier) && Objects.equals(this.enhancedAuth, that.enhancedAuth) && this.restrictions.equals(that.restrictions) && Objects.equals(this.responseInformation, that.responseInformation) && Objects.equals(this.serverReference, that.serverReference);
    }

    public int hashCode() {
        int result = this.partialHashCode();
        result = 31 * result + Boolean.hashCode(this.sessionPresent);
        result = 31 * result + Long.hashCode(this.sessionExpiryInterval);
        result = 31 * result + this.serverKeepAlive;
        result = 31 * result + Objects.hashCode(this.assignedClientIdentifier);
        result = 31 * result + Objects.hashCode(this.enhancedAuth);
        result = 31 * result + this.restrictions.hashCode();
        result = 31 * result + Objects.hashCode(this.responseInformation);
        result = 31 * result + Objects.hashCode(this.serverReference);
        return result;
    }
}

