/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.connect.connack;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.mqtt5.message.connect.connack.Mqtt5ConnAckRestrictions;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;

@Immutable
public class MqttConnAckRestrictions
implements Mqtt5ConnAckRestrictions {
    @NotNull
    public static final MqttConnAckRestrictions DEFAULT = new MqttConnAckRestrictions(65535, 0x10000004, 0, DEFAULT_MAXIMUM_QOS, true, true, true, true);
    private final int receiveMaximum;
    private final int maximumPacketSize;
    private final int topicAliasMaximum;
    @NotNull
    private final MqttQos maximumQos;
    private final boolean retainAvailable;
    private final boolean wildcardSubscriptionAvailable;
    private final boolean sharedSubscriptionAvailable;
    private final boolean subscriptionIdentifiersAvailable;

    public MqttConnAckRestrictions(int receiveMaximum, int maximumPacketSize, int topicAliasMaximum, @NotNull MqttQos maximumQos, boolean retainAvailable, boolean wildcardSubscriptionAvailable, boolean sharedSubscriptionAvailable, boolean subscriptionIdentifiersAvailable) {
        this.receiveMaximum = receiveMaximum;
        this.maximumPacketSize = maximumPacketSize;
        this.topicAliasMaximum = topicAliasMaximum;
        this.maximumQos = maximumQos;
        this.retainAvailable = retainAvailable;
        this.wildcardSubscriptionAvailable = wildcardSubscriptionAvailable;
        this.sharedSubscriptionAvailable = sharedSubscriptionAvailable;
        this.subscriptionIdentifiersAvailable = subscriptionIdentifiersAvailable;
    }

    @Override
    public int getReceiveMaximum() {
        return this.receiveMaximum;
    }

    @Override
    public int getMaximumPacketSize() {
        return this.maximumPacketSize;
    }

    @Override
    public int getTopicAliasMaximum() {
        return this.topicAliasMaximum;
    }

    @Override
    @NotNull
    public MqttQos getMaximumQos() {
        return this.maximumQos;
    }

    @Override
    public boolean isRetainAvailable() {
        return this.retainAvailable;
    }

    @Override
    public boolean isWildcardSubscriptionAvailable() {
        return this.wildcardSubscriptionAvailable;
    }

    @Override
    public boolean isSharedSubscriptionAvailable() {
        return this.sharedSubscriptionAvailable;
    }

    @Override
    public boolean areSubscriptionIdentifiersAvailable() {
        return this.subscriptionIdentifiersAvailable;
    }

    @NotNull
    private String toAttributeString() {
        return "receiveMaximum=" + this.receiveMaximum + ", maximumPacketSize=" + this.maximumPacketSize + ", topicAliasMaximum=" + this.topicAliasMaximum + ", maximumQos=" + (Object)((Object)this.maximumQos) + ", retainAvailable=" + this.retainAvailable + ", wildcardSubscriptionAvailable=" + this.wildcardSubscriptionAvailable + ", sharedSubscriptionAvailable=" + this.sharedSubscriptionAvailable + ", subscriptionIdentifiersAvailable=" + this.subscriptionIdentifiersAvailable;
    }

    @NotNull
    public String toString() {
        return "MqttConnAckRestrictions{" + this.toAttributeString() + '}';
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MqttConnAckRestrictions)) {
            return false;
        }
        MqttConnAckRestrictions that = (MqttConnAckRestrictions)o;
        return this.receiveMaximum == that.receiveMaximum && this.maximumPacketSize == that.maximumPacketSize && this.topicAliasMaximum == that.topicAliasMaximum && this.maximumQos == that.maximumQos && this.retainAvailable == that.retainAvailable && this.wildcardSubscriptionAvailable == that.wildcardSubscriptionAvailable && this.sharedSubscriptionAvailable == that.sharedSubscriptionAvailable && this.subscriptionIdentifiersAvailable == that.subscriptionIdentifiersAvailable;
    }

    public int hashCode() {
        int result = this.receiveMaximum;
        result = 31 * result + this.maximumPacketSize;
        result = 31 * result + this.topicAliasMaximum;
        result = 31 * result + this.maximumQos.hashCode();
        result = 31 * result + Boolean.hashCode(this.retainAvailable);
        result = 31 * result + Boolean.hashCode(this.wildcardSubscriptionAvailable);
        result = 31 * result + Boolean.hashCode(this.sharedSubscriptionAvailable);
        result = 31 * result + Boolean.hashCode(this.subscriptionIdentifiersAvailable);
        return result;
    }
}

