/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.connect.mqtt3;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.message.auth.MqttSimpleAuth;
import com.hivemq.client.internal.mqtt.message.auth.mqtt3.Mqtt3SimpleAuthView;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnectRestrictions;
import com.hivemq.client.internal.mqtt.message.connect.mqtt3.Mqtt3ConnectViewBuilder;
import com.hivemq.client.internal.mqtt.message.publish.MqttWillPublish;
import com.hivemq.client.internal.mqtt.message.publish.mqtt3.Mqtt3PublishView;
import com.hivemq.client.mqtt.mqtt3.message.auth.Mqtt3SimpleAuth;
import com.hivemq.client.mqtt.mqtt3.message.connect.Mqtt3Connect;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3Publish;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;
import java.util.Optional;

@Immutable
public class Mqtt3ConnectView
implements Mqtt3Connect {
    @NotNull
    public static final Mqtt3ConnectView DEFAULT = Mqtt3ConnectView.of(60, true, null, null);
    @NotNull
    private final MqttConnect delegate;

    @NotNull
    private static MqttConnect delegate(int keepAlive, boolean cleanSession, @Nullable MqttSimpleAuth simpleAuth, @Nullable MqttWillPublish willPublish) {
        return new MqttConnect(keepAlive, cleanSession, cleanSession ? 0L : 0xFFFFFFFFL, MqttConnectRestrictions.DEFAULT, simpleAuth, null, willPublish, MqttUserPropertiesImpl.NO_USER_PROPERTIES);
    }

    @NotNull
    static Mqtt3ConnectView of(int keepAlive, boolean cleanSession, @Nullable MqttSimpleAuth simpleAuth, @Nullable MqttWillPublish willPublish) {
        return new Mqtt3ConnectView(Mqtt3ConnectView.delegate(keepAlive, cleanSession, simpleAuth, willPublish));
    }

    @NotNull
    public static Mqtt3ConnectView of(@NotNull MqttConnect delegate) {
        return new Mqtt3ConnectView(delegate);
    }

    private Mqtt3ConnectView(@NotNull MqttConnect delegate) {
        this.delegate = delegate;
    }

    @Override
    public int getKeepAlive() {
        return this.delegate.getKeepAlive();
    }

    @Override
    public boolean isCleanSession() {
        return this.delegate.isCleanStart();
    }

    @Override
    @NotNull
    public Optional<Mqtt3SimpleAuth> getSimpleAuth() {
        return Optional.ofNullable(this.getRawSimpleAuth());
    }

    @Nullable
    private Mqtt3SimpleAuth getRawSimpleAuth() {
        MqttSimpleAuth simpleAuth = this.delegate.getRawSimpleAuth();
        return simpleAuth == null ? null : Mqtt3SimpleAuthView.of(simpleAuth);
    }

    @Override
    @NotNull
    public Optional<Mqtt3Publish> getWillPublish() {
        return Optional.ofNullable(this.getRawWillPublish());
    }

    @Nullable
    private Mqtt3Publish getRawWillPublish() {
        MqttWillPublish willPublish = this.delegate.getRawWillPublish();
        return willPublish == null ? null : Mqtt3PublishView.of(willPublish);
    }

    @NotNull
    public MqttConnect getDelegate() {
        return this.delegate;
    }

    @Override
    @NotNull
    public Mqtt3ConnectViewBuilder.Default extend() {
        return new Mqtt3ConnectViewBuilder.Default(this);
    }

    @NotNull
    private String toAttributeString() {
        Mqtt3SimpleAuth simpleAuth = this.getRawSimpleAuth();
        Mqtt3Publish willPublish = this.getRawWillPublish();
        return "keepAlive=" + this.getKeepAlive() + ", cleanSession=" + this.isCleanSession() + (simpleAuth == null ? "" : ", simpleAuth=" + simpleAuth) + (willPublish == null ? "" : ", willPublish=" + willPublish);
    }

    @NotNull
    public String toString() {
        return "MqttConnect{" + this.toAttributeString() + '}';
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Mqtt3ConnectView)) {
            return false;
        }
        Mqtt3ConnectView that = (Mqtt3ConnectView)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

