/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.disconnect;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.message.MqttMessageWithUserProperties;
import com.hivemq.client.internal.mqtt.message.disconnect.MqttDisconnectBuilder;
import com.hivemq.client.internal.util.StringUtil;
import com.hivemq.client.mqtt.datatypes.MqttUtf8String;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5Disconnect;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5DisconnectReasonCode;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

@Immutable
public class MqttDisconnect
extends MqttMessageWithUserProperties.WithReason.WithCode<Mqtt5DisconnectReasonCode>
implements Mqtt5Disconnect {
    public static final long SESSION_EXPIRY_INTERVAL_FROM_CONNECT = -1L;
    @NotNull
    public static final MqttDisconnect DEFAULT = new MqttDisconnect(DEFAULT_REASON_CODE, -1L, null, null, MqttUserPropertiesImpl.NO_USER_PROPERTIES);
    private final long sessionExpiryInterval;
    @Nullable
    private final MqttUtf8StringImpl serverReference;

    public MqttDisconnect(@NotNull Mqtt5DisconnectReasonCode reasonCode, long sessionExpiryInterval, @Nullable MqttUtf8StringImpl serverReference, @Nullable MqttUtf8StringImpl reasonString, @NotNull MqttUserPropertiesImpl userProperties) {
        super(reasonCode, reasonString, userProperties);
        this.sessionExpiryInterval = sessionExpiryInterval;
        this.serverReference = serverReference;
    }

    @Override
    @NotNull
    public OptionalLong getSessionExpiryInterval() {
        return this.sessionExpiryInterval == -1L ? OptionalLong.empty() : OptionalLong.of(this.sessionExpiryInterval);
    }

    public long getRawSessionExpiryInterval() {
        return this.sessionExpiryInterval;
    }

    @Override
    @NotNull
    public Optional<MqttUtf8String> getServerReference() {
        return Optional.ofNullable(this.serverReference);
    }

    @Nullable
    public MqttUtf8StringImpl getRawServerReference() {
        return this.serverReference;
    }

    @Override
    @NotNull
    public MqttDisconnectBuilder.Default extend() {
        return new MqttDisconnectBuilder.Default(this);
    }

    @Override
    @NotNull
    protected String toAttributeString() {
        return "reasonCode=" + this.getReasonCode() + (this.sessionExpiryInterval == -1L ? "" : ", sessionExpiryInterval=" + this.sessionExpiryInterval) + (this.serverReference == null ? "" : ", serverReference=" + this.serverReference) + StringUtil.prepend(", ", super.toAttributeString());
    }

    @NotNull
    public String toString() {
        return "MqttDisconnect{" + this.toAttributeString() + '}';
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MqttDisconnect)) {
            return false;
        }
        MqttDisconnect that = (MqttDisconnect)o;
        return this.partialEquals(that) && this.sessionExpiryInterval == that.sessionExpiryInterval && Objects.equals(this.serverReference, that.serverReference);
    }

    public int hashCode() {
        int result = this.partialHashCode();
        result = 31 * result + Long.hashCode(this.sessionExpiryInterval);
        result = 31 * result + Objects.hashCode(this.serverReference);
        return result;
    }
}

