/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.publish;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttTopicAliasMapping;
import com.hivemq.client.internal.mqtt.message.MqttMessageWithUserProperties;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublishBuilder;
import com.hivemq.client.internal.mqtt.message.publish.MqttStatefulPublish;
import com.hivemq.client.internal.mqtt.message.publish.MqttWillPublish;
import com.hivemq.client.internal.util.ByteBufferUtil;
import com.hivemq.client.internal.util.StringUtil;
import com.hivemq.client.internal.util.collections.ImmutableIntList;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.datatypes.MqttTopic;
import com.hivemq.client.mqtt.datatypes.MqttUtf8String;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5PayloadFormatIndicator;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5Publish;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

@Immutable
public class MqttPublish
extends MqttMessageWithUserProperties
implements Mqtt5Publish {
    public static final long NO_MESSAGE_EXPIRY = Long.MAX_VALUE;
    @NotNull
    private final MqttTopicImpl topic;
    @Nullable
    private final ByteBuffer payload;
    @NotNull
    private final MqttQos qos;
    private final boolean retain;
    private final long messageExpiryInterval;
    @Nullable
    private final Mqtt5PayloadFormatIndicator payloadFormatIndicator;
    @Nullable
    private final MqttUtf8StringImpl contentType;
    @Nullable
    private final MqttTopicImpl responseTopic;
    @Nullable
    private final ByteBuffer correlationData;

    public MqttPublish(@NotNull MqttTopicImpl topic, @Nullable ByteBuffer payload, @NotNull MqttQos qos, boolean retain, long messageExpiryInterval, @Nullable Mqtt5PayloadFormatIndicator payloadFormatIndicator, @Nullable MqttUtf8StringImpl contentType, @Nullable MqttTopicImpl responseTopic, @Nullable ByteBuffer correlationData, @NotNull MqttUserPropertiesImpl userProperties) {
        super(userProperties);
        this.topic = topic;
        this.payload = payload;
        this.qos = qos;
        this.retain = retain;
        this.messageExpiryInterval = messageExpiryInterval;
        this.payloadFormatIndicator = payloadFormatIndicator;
        this.contentType = contentType;
        this.responseTopic = responseTopic;
        this.correlationData = correlationData;
    }

    @Override
    @NotNull
    public MqttTopicImpl getTopic() {
        return this.topic;
    }

    @Override
    @NotNull
    public Optional<ByteBuffer> getPayload() {
        return ByteBufferUtil.optionalReadOnly(this.payload);
    }

    @Nullable
    public ByteBuffer getRawPayload() {
        return this.payload;
    }

    @Override
    @NotNull
    public byte[] getPayloadAsBytes() {
        return ByteBufferUtil.copyBytes(this.payload);
    }

    @Override
    @NotNull
    public MqttQos getQos() {
        return this.qos;
    }

    @Override
    public boolean isRetain() {
        return this.retain;
    }

    @Override
    @NotNull
    public OptionalLong getMessageExpiryInterval() {
        return this.messageExpiryInterval == Long.MAX_VALUE ? OptionalLong.empty() : OptionalLong.of(this.messageExpiryInterval);
    }

    public long getRawMessageExpiryInterval() {
        return this.messageExpiryInterval;
    }

    @Override
    @NotNull
    public Optional<Mqtt5PayloadFormatIndicator> getPayloadFormatIndicator() {
        return Optional.ofNullable(this.payloadFormatIndicator);
    }

    @Nullable
    public Mqtt5PayloadFormatIndicator getRawPayloadFormatIndicator() {
        return this.payloadFormatIndicator;
    }

    @Override
    @NotNull
    public Optional<MqttUtf8String> getContentType() {
        return Optional.ofNullable(this.contentType);
    }

    @Nullable
    public MqttUtf8StringImpl getRawContentType() {
        return this.contentType;
    }

    @Override
    @NotNull
    public Optional<MqttTopic> getResponseTopic() {
        return Optional.ofNullable(this.responseTopic);
    }

    @Nullable
    public MqttTopicImpl getRawResponseTopic() {
        return this.responseTopic;
    }

    @Override
    @NotNull
    public Optional<ByteBuffer> getCorrelationData() {
        return ByteBufferUtil.optionalReadOnly(this.correlationData);
    }

    @Nullable
    public ByteBuffer getRawCorrelationData() {
        return this.correlationData;
    }

    @Override
    @NotNull
    public MqttWillPublish asWill() {
        return new MqttPublishBuilder.WillDefault(this).build();
    }

    @Override
    @NotNull
    public MqttPublishBuilder.Default extend() {
        return new MqttPublishBuilder.Default(this);
    }

    @NotNull
    public MqttStatefulPublish createStateful(int packetIdentifier, boolean dup, int topicAlias, @NotNull ImmutableIntList subscriptionIdentifiers) {
        return new MqttStatefulPublish(this, packetIdentifier, dup, topicAlias, subscriptionIdentifiers);
    }

    @NotNull
    public MqttStatefulPublish createStateful(int packetIdentifier, boolean dup, @Nullable MqttTopicAliasMapping topicAliasMapping) {
        int topicAlias = topicAliasMapping == null ? 0 : topicAliasMapping.onPublish(this.topic);
        return this.createStateful(packetIdentifier, dup, topicAlias, MqttStatefulPublish.DEFAULT_NO_SUBSCRIPTION_IDENTIFIERS);
    }

    @Override
    @NotNull
    protected String toAttributeString() {
        return "topic=" + this.topic + (this.payload == null ? "" : ", payload=" + this.payload.remaining() + "byte") + ", qos=" + (Object)((Object)this.qos) + ", retain=" + this.retain + (this.messageExpiryInterval == Long.MAX_VALUE ? "" : ", messageExpiryInterval=" + this.messageExpiryInterval) + (this.payloadFormatIndicator == null ? "" : ", payloadFormatIndicator=" + (Object)((Object)this.payloadFormatIndicator)) + (this.contentType == null ? "" : ", contentType=" + this.contentType) + (this.responseTopic == null ? "" : ", responseTopic=" + this.responseTopic) + (this.correlationData == null ? "" : ", correlationData=" + this.correlationData) + StringUtil.prepend(", ", super.toAttributeString());
    }

    @NotNull
    public String toString() {
        return "MqttPublish{" + this.toAttributeString() + '}';
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MqttPublish)) {
            return false;
        }
        MqttPublish that = (MqttPublish)o;
        return that.canEqual(this) && this.partialEquals(that) && this.topic.equals(that.topic) && Objects.equals(this.payload, that.payload) && this.qos == that.qos && this.retain == that.retain && this.messageExpiryInterval == that.messageExpiryInterval && this.payloadFormatIndicator == that.payloadFormatIndicator && Objects.equals(this.contentType, that.contentType) && Objects.equals(this.responseTopic, that.responseTopic) && Objects.equals(this.correlationData, that.correlationData);
    }

    protected boolean canEqual(@Nullable Object o) {
        return o instanceof MqttPublish;
    }

    public int hashCode() {
        int result = this.partialHashCode();
        result = 31 * result + this.topic.hashCode();
        result = 31 * result + Objects.hashCode(this.payload);
        result = 31 * result + this.qos.hashCode();
        result = 31 * result + Boolean.hashCode(this.retain);
        result = 31 * result + Long.hashCode(this.messageExpiryInterval);
        result = 31 * result + Objects.hashCode((Object)this.payloadFormatIndicator);
        result = 31 * result + Objects.hashCode(this.contentType);
        result = 31 * result + Objects.hashCode(this.responseTopic);
        result = 31 * result + Objects.hashCode(this.correlationData);
        return result;
    }
}

