/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.publish;

import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.mqtt.message.publish.puback.MqttPubAck;
import com.hivemq.client.internal.mqtt.message.publish.pubcomp.MqttPubComp;
import com.hivemq.client.internal.mqtt.message.publish.pubrec.MqttPubRec;
import com.hivemq.client.internal.mqtt.message.publish.pubrel.MqttPubRel;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5PublishResult;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BooleanSupplier;

public class MqttPublishResult
implements Mqtt5PublishResult {
    @NotNull
    private final MqttPublish publish;
    @Nullable
    private final Throwable error;

    public MqttPublishResult(@NotNull MqttPublish publish, @Nullable Throwable error) {
        this.publish = publish;
        this.error = error;
    }

    @Override
    @NotNull
    public MqttPublish getPublish() {
        return this.publish;
    }

    @Override
    @NotNull
    public Optional<Throwable> getError() {
        return Optional.ofNullable(this.error);
    }

    public boolean acknowledged() {
        return true;
    }

    @NotNull
    String toAttributeString() {
        return "publish=" + this.publish + (this.error == null ? "" : ", error=" + this.error);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MqttPublishResult)) {
            return false;
        }
        MqttPublishResult that = (MqttPublishResult)o;
        return that.canEqual(this) && this.publish.equals(that.publish) && Objects.equals(this.error, that.error);
    }

    protected boolean canEqual(@Nullable Object o) {
        return o instanceof MqttPublishResult;
    }

    public int hashCode() {
        int result = this.publish.hashCode();
        result = 31 * result + Objects.hashCode(this.error);
        return result;
    }

    @NotNull
    public String toString() {
        return "MqttPublishResult{" + this.toAttributeString() + '}';
    }

    public static class MqttQos2CompleteResult
    extends MqttQos2Result
    implements Mqtt5PublishResult.Mqtt5Qos2CompleteResult {
        @NotNull
        private final MqttPubRel pubRel;
        @NotNull
        private final MqttPubComp pubComp;

        public MqttQos2CompleteResult(@NotNull MqttPublish publish, @NotNull MqttPubRec pubRec, @NotNull MqttPubRel pubRel, @NotNull MqttPubComp pubComp) {
            super(publish, null, pubRec);
            this.pubRel = pubRel;
            this.pubComp = pubComp;
        }

        @Override
        @NotNull
        public MqttPubRel getPubRel() {
            return this.pubRel;
        }

        @Override
        @NotNull
        public MqttPubComp getPubComp() {
            return this.pubComp;
        }

        @Override
        @NotNull
        String toAttributeString() {
            return super.toAttributeString() + ", pubRel=" + this.pubRel + ", pubComp=" + this.pubComp;
        }

        @Override
        @NotNull
        public String toString() {
            return "MqttQos2CompleteResult{" + this.toAttributeString() + '}';
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MqttQos2CompleteResult) || !super.equals(o)) {
                return false;
            }
            MqttQos2CompleteResult that = (MqttQos2CompleteResult)o;
            return this.pubRel.equals(that.pubRel) && this.pubComp.equals(that.pubComp);
        }

        @Override
        protected boolean canEqual(@Nullable Object o) {
            return o instanceof MqttQos2CompleteResult;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.pubRel.hashCode();
            result = 31 * result + this.pubComp.hashCode();
            return result;
        }
    }

    public static class MqttQos2IntermediateResult
    extends MqttQos2Result {
        @NotNull
        private final BooleanSupplier acknowledgedCallback;

        public MqttQos2IntermediateResult(@NotNull MqttPublish publish, @NotNull MqttPubRec pubRec, @NotNull BooleanSupplier acknowledgedCallback) {
            super(publish, null, pubRec);
            this.acknowledgedCallback = acknowledgedCallback;
        }

        @Override
        public boolean acknowledged() {
            return this.acknowledgedCallback.getAsBoolean();
        }
    }

    public static class MqttQos2Result
    extends MqttPublishResult
    implements Mqtt5PublishResult.Mqtt5Qos2Result {
        @NotNull
        private final MqttPubRec pubRec;

        public MqttQos2Result(@NotNull MqttPublish publish, @Nullable Throwable error, @NotNull MqttPubRec pubRec) {
            super(publish, error);
            this.pubRec = pubRec;
        }

        @Override
        @NotNull
        public MqttPubRec getPubRec() {
            return this.pubRec;
        }

        @Override
        @NotNull
        String toAttributeString() {
            return super.toAttributeString() + ", pubRec=" + this.pubRec;
        }

        @Override
        @NotNull
        public String toString() {
            return "MqttQos2PublishResult{" + this.toAttributeString() + '}';
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MqttQos2Result) || !super.equals(o)) {
                return false;
            }
            MqttQos2Result that = (MqttQos2Result)o;
            return this.pubRec.equals(that.pubRec);
        }

        @Override
        protected boolean canEqual(@Nullable Object o) {
            return o instanceof MqttQos2Result;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.pubRec.hashCode();
            return result;
        }
    }

    public static class MqttQos1Result
    extends MqttPublishResult
    implements Mqtt5PublishResult.Mqtt5Qos1Result {
        @NotNull
        private final MqttPubAck pubAck;

        public MqttQos1Result(@NotNull MqttPublish publish, @Nullable Throwable error, @NotNull MqttPubAck pubAck) {
            super(publish, error);
            this.pubAck = pubAck;
        }

        @Override
        @NotNull
        public MqttPubAck getPubAck() {
            return this.pubAck;
        }

        @Override
        @NotNull
        String toAttributeString() {
            return super.toAttributeString() + ", pubAck=" + this.pubAck;
        }

        @Override
        @NotNull
        public String toString() {
            return "MqttQos1Result{" + this.toAttributeString() + '}';
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MqttQos1Result) || !super.equals(o)) {
                return false;
            }
            MqttQos1Result that = (MqttQos1Result)o;
            return this.pubAck.equals(that.pubAck);
        }

        @Override
        protected boolean canEqual(@Nullable Object o) {
            return o instanceof MqttQos1Result;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.pubAck.hashCode();
            return result;
        }
    }
}

