/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.publish;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.mqtt.message.MqttStatefulMessage;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.util.collections.ImmutableIntList;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;

@Immutable
public class MqttStatefulPublish
extends MqttStatefulMessage.WithId<MqttPublish> {
    public static final int NO_PACKET_IDENTIFIER_QOS_0 = -1;
    public static final int DEFAULT_NO_TOPIC_ALIAS = 0;
    public static final int TOPIC_ALIAS_FLAG = 65535;
    public static final int TOPIC_ALIAS_FLAG_NEW = 65536;
    @NotNull
    public static final ImmutableIntList DEFAULT_NO_SUBSCRIPTION_IDENTIFIERS = ImmutableIntList.of();
    private final boolean dup;
    private final int topicAlias;
    @NotNull
    private final ImmutableIntList subscriptionIdentifiers;

    MqttStatefulPublish(@NotNull MqttPublish publish, int packetIdentifier, boolean dup, int topicAlias, @NotNull ImmutableIntList subscriptionIdentifiers) {
        super(publish, packetIdentifier);
        this.dup = dup;
        this.topicAlias = topicAlias;
        this.subscriptionIdentifiers = subscriptionIdentifiers;
    }

    public boolean isDup() {
        return this.dup;
    }

    public int getTopicAlias() {
        return this.topicAlias & 0xFFFF;
    }

    public boolean isNewTopicAlias() {
        return (this.topicAlias & 0x10000) != 0;
    }

    @NotNull
    public ImmutableIntList getSubscriptionIdentifiers() {
        return this.subscriptionIdentifiers;
    }

    @Override
    @NotNull
    protected String toAttributeString() {
        return super.toAttributeString() + ", dup=" + this.dup + ", topicAlias=" + this.topicAlias + ", subscriptionIdentifiers=" + this.subscriptionIdentifiers;
    }

    @NotNull
    public String toString() {
        return "MqttStatefulPublish{" + this.toAttributeString() + '}';
    }
}

