/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.subscribe;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImpl;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.Mqtt5RetainHandling;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.Mqtt5Subscription;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;

@Immutable
public class MqttSubscription
implements Mqtt5Subscription {
    @NotNull
    private final MqttTopicFilterImpl topicFilter;
    @NotNull
    private final MqttQos qos;
    private final boolean noLocal;
    @NotNull
    private final Mqtt5RetainHandling retainHandling;
    private final boolean retainAsPublished;

    public MqttSubscription(@NotNull MqttTopicFilterImpl topicFilter, @NotNull MqttQos qos, boolean noLocal, @NotNull Mqtt5RetainHandling retainHandling, boolean retainAsPublished) {
        this.topicFilter = topicFilter;
        this.qos = qos;
        this.noLocal = noLocal;
        this.retainHandling = retainHandling;
        this.retainAsPublished = retainAsPublished;
    }

    @Override
    @NotNull
    public MqttTopicFilterImpl getTopicFilter() {
        return this.topicFilter;
    }

    @Override
    @NotNull
    public MqttQos getQos() {
        return this.qos;
    }

    @Override
    public boolean isNoLocal() {
        return this.noLocal;
    }

    @Override
    @NotNull
    public Mqtt5RetainHandling getRetainHandling() {
        return this.retainHandling;
    }

    @Override
    public boolean isRetainAsPublished() {
        return this.retainAsPublished;
    }

    @NotNull
    private String toAttributeString() {
        return "topicFilter=" + this.topicFilter + ", qos=" + (Object)((Object)this.qos) + ", noLocal=" + this.noLocal + ", retainHandling=" + (Object)((Object)this.retainHandling) + ", retainAsPublished=" + this.retainAsPublished;
    }

    @NotNull
    public String toString() {
        return "MqttSubscription{" + this.toAttributeString() + '}';
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MqttSubscription)) {
            return false;
        }
        MqttSubscription that = (MqttSubscription)o;
        return this.topicFilter.equals(that.topicFilter) && this.qos == that.qos && this.noLocal == that.noLocal && this.retainHandling == that.retainHandling && this.retainAsPublished == that.retainAsPublished;
    }

    public int hashCode() {
        int result = this.topicFilter.hashCode();
        result = 31 * result + this.qos.hashCode();
        result = 31 * result + Boolean.hashCode(this.noLocal);
        result = 31 * result + this.retainHandling.hashCode();
        result = 31 * result + Boolean.hashCode(this.retainAsPublished);
        return result;
    }
}

