/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.unsubscribe;

import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImplBuilder;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImplBuilder;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscription;
import com.hivemq.client.internal.mqtt.message.unsubscribe.MqttUnsubscribe;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.client.mqtt.datatypes.MqttTopicFilter;
import com.hivemq.client.mqtt.mqtt5.datatypes.Mqtt5UserProperties;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.Mqtt5Subscribe;
import com.hivemq.client.mqtt.mqtt5.message.unsubscribe.Mqtt5UnsubscribeBuilder;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;
import java.util.List;
import java.util.function.Function;

public abstract class MqttUnsubscribeBuilder<B extends MqttUnsubscribeBuilder<B>> {
    @NotNull
    private final ImmutableList.Builder<MqttTopicFilterImpl> topicFiltersBuilder;
    @NotNull
    private MqttUserPropertiesImpl userProperties = MqttUserPropertiesImpl.NO_USER_PROPERTIES;

    MqttUnsubscribeBuilder() {
        this.topicFiltersBuilder = ImmutableList.builder();
    }

    MqttUnsubscribeBuilder(@NotNull MqttUnsubscribe unsubscribe) {
        List topicFilters = unsubscribe.getTopicFilters();
        this.topicFiltersBuilder = ImmutableList.builder(topicFilters.size() + 1);
        this.topicFiltersBuilder.addAll(topicFilters);
    }

    @NotNull
    abstract B self();

    @NotNull
    public B addTopicFilter(@Nullable String topicFilter) {
        this.topicFiltersBuilder.add(MqttTopicFilterImpl.of(topicFilter));
        return this.self();
    }

    @NotNull
    public B addTopicFilter(@Nullable MqttTopicFilter topicFilter) {
        this.topicFiltersBuilder.add(MqttChecks.topicFilter(topicFilter));
        return this.self();
    }

    @NotNull
    public MqttTopicFilterImplBuilder.Nested<B> addTopicFilter() {
        return new MqttTopicFilterImplBuilder.Nested<MqttUnsubscribeBuilder>(this::addTopicFilter);
    }

    @NotNull
    public B reverse(@Nullable Mqtt5Subscribe subscribe) {
        List subscriptions = MqttChecks.subscribe(subscribe).getSubscriptions();
        for (MqttSubscription subscription : subscriptions) {
            this.topicFiltersBuilder.add(subscription.getTopicFilter());
        }
        return this.self();
    }

    @NotNull
    public B userProperties(@Nullable Mqtt5UserProperties userProperties) {
        this.userProperties = MqttChecks.userProperties(userProperties);
        return this.self();
    }

    @NotNull
    public MqttUserPropertiesImplBuilder.Nested<B> userProperties() {
        return new MqttUserPropertiesImplBuilder.Nested<MqttUnsubscribeBuilder>(this.userProperties, this::userProperties);
    }

    @NotNull
    public B topicFilter(@Nullable String topicFilter) {
        return this.addTopicFilter(topicFilter);
    }

    @NotNull
    public B topicFilter(@Nullable MqttTopicFilter topicFilter) {
        return this.addTopicFilter(topicFilter);
    }

    @NotNull
    public MqttTopicFilterImplBuilder.Nested<B> topicFilter() {
        return new MqttTopicFilterImplBuilder.Nested<MqttUnsubscribeBuilder>(this::topicFilter);
    }

    @NotNull
    public MqttUnsubscribe build() {
        ImmutableList<MqttTopicFilterImpl> topicFilters = this.topicFiltersBuilder.build();
        if (topicFilters.isEmpty()) {
            throw new IllegalStateException("At least one topic filter must be added.");
        }
        return new MqttUnsubscribe(topicFilters, this.userProperties);
    }

    public static class Send<P>
    extends MqttUnsubscribeBuilder<Send<P>>
    implements Mqtt5UnsubscribeBuilder.Send.Complete<P>,
    Mqtt5UnsubscribeBuilder.Send.Start<P> {
        @NotNull
        private final Function<? super MqttUnsubscribe, P> parentConsumer;

        public Send(@NotNull Function<? super MqttUnsubscribe, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Send<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P send() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Nested<P>
    extends MqttUnsubscribeBuilder<Nested<P>>
    implements Mqtt5UnsubscribeBuilder.Nested.Complete<P>,
    Mqtt5UnsubscribeBuilder.Nested.Start<P> {
        @NotNull
        private final Function<? super MqttUnsubscribe, P> parentConsumer;

        public Nested(@NotNull Function<? super MqttUnsubscribe, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Nested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applyUnsubscribe() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Default
    extends MqttUnsubscribeBuilder<Default>
    implements Mqtt5UnsubscribeBuilder.Complete,
    Mqtt5UnsubscribeBuilder.Start {
        public Default() {
        }

        Default(@NotNull MqttUnsubscribe unsubscribe) {
            super(unsubscribe);
        }

        @Override
        @NotNull
        Default self() {
            return this;
        }
    }
}

