/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.mqtt3.exceptions;

import com.hivemq.client.internal.mqtt.message.connect.connack.MqttConnAck;
import com.hivemq.client.internal.mqtt.message.connect.connack.mqtt3.Mqtt3ConnAckView;
import com.hivemq.client.internal.mqtt.message.subscribe.suback.MqttSubAck;
import com.hivemq.client.internal.mqtt.message.subscribe.suback.mqtt3.Mqtt3SubAckView;
import com.hivemq.client.mqtt.mqtt3.exceptions.Mqtt3ConnAckException;
import com.hivemq.client.mqtt.mqtt3.exceptions.Mqtt3DisconnectException;
import com.hivemq.client.mqtt.mqtt3.exceptions.Mqtt3MessageException;
import com.hivemq.client.mqtt.mqtt3.exceptions.Mqtt3PubAckException;
import com.hivemq.client.mqtt.mqtt3.exceptions.Mqtt3PubRecException;
import com.hivemq.client.mqtt.mqtt3.exceptions.Mqtt3SubAckException;
import com.hivemq.client.mqtt.mqtt3.exceptions.Mqtt3UnsubAckException;
import com.hivemq.client.mqtt.mqtt5.exceptions.Mqtt5MessageException;
import com.hivemq.client.mqtt.mqtt5.message.Mqtt5Message;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import java.util.function.Function;

public final class Mqtt3ExceptionFactory {
    @NotNull
    public static final io.reactivex.functions.Function<Throwable, Throwable> MAPPER = Mqtt3ExceptionFactory::map;
    @NotNull
    public static final Function<Throwable, Throwable> MAPPER_JAVA = Mqtt3ExceptionFactory::map;

    @NotNull
    public static Throwable map(@NotNull Throwable throwable) {
        if (throwable instanceof Mqtt5MessageException) {
            return Mqtt3ExceptionFactory.map((Mqtt5MessageException)throwable);
        }
        return throwable;
    }

    @NotNull
    public static Mqtt3MessageException map(@NotNull Mqtt5MessageException mqtt5MessageException) {
        Mqtt5Message mqttMessage = mqtt5MessageException.getMqttMessage();
        String message = mqtt5MessageException.getMessage();
        Throwable cause = mqtt5MessageException.getCause();
        switch (mqttMessage.getType()) {
            case CONNACK: {
                return new Mqtt3ConnAckException(Mqtt3ConnAckView.of((MqttConnAck)mqttMessage), message, cause);
            }
            case DISCONNECT: {
                return new Mqtt3DisconnectException(message, cause);
            }
            case PUBACK: {
                return new Mqtt3PubAckException(message, cause);
            }
            case PUBREC: {
                return new Mqtt3PubRecException(message, cause);
            }
            case SUBACK: {
                return new Mqtt3SubAckException(Mqtt3SubAckView.of((MqttSubAck)mqttMessage), message, cause);
            }
            case UNSUBACK: {
                return new Mqtt3UnsubAckException(message, cause);
            }
        }
        throw new IllegalStateException();
    }

    private Mqtt3ExceptionFactory() {
    }
}

