/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.util;

import com.hivemq.client.internal.mqtt.datatypes.MqttBinaryData;
import com.hivemq.client.internal.mqtt.datatypes.MqttClientIdentifierImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertyImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.internal.mqtt.message.connect.mqtt3.Mqtt3ConnectView;
import com.hivemq.client.internal.mqtt.message.disconnect.MqttDisconnect;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.mqtt.message.publish.mqtt3.Mqtt3PublishView;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscribe;
import com.hivemq.client.internal.mqtt.message.subscribe.mqtt3.Mqtt3SubscribeView;
import com.hivemq.client.internal.mqtt.message.unsubscribe.MqttUnsubscribe;
import com.hivemq.client.internal.mqtt.message.unsubscribe.mqtt3.Mqtt3UnsubscribeView;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.client.mqtt.datatypes.MqttClientIdentifier;
import com.hivemq.client.mqtt.datatypes.MqttTopic;
import com.hivemq.client.mqtt.datatypes.MqttTopicFilter;
import com.hivemq.client.mqtt.datatypes.MqttUtf8String;
import com.hivemq.client.mqtt.mqtt3.message.connect.Mqtt3Connect;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3Publish;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.Mqtt3Subscribe;
import com.hivemq.client.mqtt.mqtt3.message.unsubscribe.Mqtt3Unsubscribe;
import com.hivemq.client.mqtt.mqtt5.datatypes.Mqtt5UserProperties;
import com.hivemq.client.mqtt.mqtt5.datatypes.Mqtt5UserProperty;
import com.hivemq.client.mqtt.mqtt5.message.connect.Mqtt5Connect;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5Disconnect;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5Publish;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.Mqtt5Subscribe;
import com.hivemq.client.mqtt.mqtt5.message.unsubscribe.Mqtt5Unsubscribe;
import com.hivemq.shaded.org.jetbrains.annotations.Contract;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.Collection;

public final class MqttChecks {
    @Contract(value="null, _ -> fail")
    @NotNull
    public static MqttUtf8StringImpl string(@Nullable MqttUtf8String string, @NotNull String name) {
        return Checks.notImplemented(string, MqttUtf8StringImpl.class, name);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static MqttUtf8StringImpl stringOrNull(@Nullable String string, @NotNull String name) {
        return string == null ? null : MqttUtf8StringImpl.of(string, name);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static MqttUtf8StringImpl stringOrNull(@Nullable MqttUtf8String string, @NotNull String name) {
        return Checks.notImplementedOrNull(string, MqttUtf8StringImpl.class, name);
    }

    @Contract(value="null -> null")
    @Nullable
    public static MqttUtf8StringImpl reasonString(@Nullable String reasonString) {
        return MqttChecks.stringOrNull(reasonString, "Reason string");
    }

    @Contract(value="null -> null")
    @Nullable
    public static MqttUtf8StringImpl reasonString(@Nullable MqttUtf8String reasonString) {
        return MqttChecks.stringOrNull(reasonString, "Reason string");
    }

    @Contract(value="null -> fail")
    @NotNull
    public static MqttTopicImpl topic(@Nullable MqttTopic topic) {
        return Checks.notImplemented(topic, MqttTopicImpl.class, "Topic");
    }

    @Contract(value="null -> fail")
    @NotNull
    public static MqttTopicFilterImpl topicFilter(@Nullable MqttTopicFilter topicFilter) {
        return Checks.notImplemented(topicFilter, MqttTopicFilterImpl.class, "Topic filter");
    }

    @Contract(value="null -> fail")
    @NotNull
    public static MqttClientIdentifierImpl clientIdentifier(@Nullable MqttClientIdentifier clientIdentifier) {
        return Checks.notImplemented(clientIdentifier, MqttClientIdentifierImpl.class, "Client identifier");
    }

    @NotNull
    private static ByteBuffer binaryDataInternal(@NotNull byte[] binary, @NotNull String name) {
        if (!MqttBinaryData.isInRange(binary)) {
            throw new IllegalArgumentException(name + " can not be encoded as binary data. Maximum length is " + 65535 + " bytes, but was " + binary.length + " bytes.");
        }
        return ByteBuffer.wrap(binary);
    }

    @Contract(value="null, _ -> fail")
    @NotNull
    public static ByteBuffer binaryData(@Nullable byte[] binary, @NotNull String name) {
        return MqttChecks.binaryDataInternal(Checks.notNull(binary, name), name);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static ByteBuffer binaryDataOrNull(@Nullable byte[] binary, @NotNull String name) {
        return binary == null ? null : MqttChecks.binaryDataInternal(binary, name);
    }

    @NotNull
    private static ByteBuffer binaryDataInternal(@NotNull ByteBuffer binary, @NotNull String name) {
        if (!MqttBinaryData.isInRange(binary)) {
            throw new IllegalArgumentException(name + " can not be encoded as binary data. Maximum length is " + 65535 + " bytes, but was " + binary.remaining() + " bytes.");
        }
        return binary.slice();
    }

    @Contract(value="null, _ -> fail")
    @NotNull
    public static ByteBuffer binaryData(@Nullable ByteBuffer binary, @NotNull String name) {
        return MqttChecks.binaryDataInternal(Checks.notNull(binary, name), name);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static ByteBuffer binaryDataOrNull(@Nullable ByteBuffer binary, @NotNull String name) {
        return binary == null ? null : MqttChecks.binaryDataInternal(binary, name);
    }

    @Contract(value="null -> fail")
    @NotNull
    public static MqttUserPropertiesImpl userProperties(@Nullable Mqtt5UserProperties userProperties) {
        return Checks.notImplemented(userProperties, MqttUserPropertiesImpl.class, "User properties");
    }

    @Contract(value="null -> fail")
    @NotNull
    public static MqttUserPropertiesImpl userProperties(Mqtt5UserProperty ... userProperties) {
        ImmutableList<Mqtt5UserProperty> immutable = ImmutableList.copyOf(userProperties, "User properties");
        return MqttUserPropertiesImpl.of(Checks.elementsNotImplemented(immutable, MqttUserPropertyImpl.class, "User property"));
    }

    @Contract(value="null -> fail")
    @NotNull
    public static MqttUserPropertiesImpl userProperties(@Nullable @Nullable Collection<@Nullable Mqtt5UserProperty> userProperties) {
        ImmutableList<Mqtt5UserProperty> immutable = ImmutableList.copyOf(userProperties, "User properties");
        return MqttUserPropertiesImpl.of(Checks.elementsNotImplemented(immutable, MqttUserPropertyImpl.class, "User property"));
    }

    @Contract(value="null -> fail")
    @NotNull
    public static MqttUserPropertyImpl userProperty(@Nullable Mqtt5UserProperty userProperty) {
        return Checks.notImplemented(userProperty, MqttUserPropertyImpl.class, "User property");
    }

    @Contract(value="null, _ -> fail; _, null -> fail")
    @NotNull
    public static MqttUserPropertyImpl userProperty(@Nullable MqttUtf8String name, @Nullable MqttUtf8String value) {
        return MqttUserPropertyImpl.of(MqttChecks.string(name, "User property name"), MqttChecks.string(value, "User property value"));
    }

    public static int packetSize(int packetSize, @NotNull String name) {
        if (packetSize <= 0 || packetSize > 0x10000004) {
            throw new IllegalArgumentException(name + " must not exceed the value range of ]0, " + 0x10000004 + "], but was " + packetSize + ".");
        }
        return packetSize;
    }

    @Contract(value="null -> fail")
    @NotNull
    public static MqttConnect connect(@Nullable Mqtt5Connect connect) {
        return Checks.notImplemented(connect, MqttConnect.class, "Connect");
    }

    @Contract(value="null -> fail")
    @NotNull
    public static MqttConnect connect(@Nullable Mqtt3Connect connect) {
        return Checks.notImplemented(connect, Mqtt3ConnectView.class, "Connect").getDelegate();
    }

    @Contract(value="null -> fail")
    @NotNull
    public static MqttPublish publish(@Nullable Mqtt5Publish publish) {
        return Checks.notImplemented(publish, MqttPublish.class, "Publish");
    }

    @Contract(value="null -> fail")
    @NotNull
    public static MqttPublish publish(@Nullable Mqtt3Publish publish) {
        return Checks.notImplemented(publish, Mqtt3PublishView.class, "Publish").getDelegate();
    }

    @Contract(value="null -> fail")
    @NotNull
    public static MqttSubscribe subscribe(@Nullable Mqtt5Subscribe subscribe) {
        return Checks.notImplemented(subscribe, MqttSubscribe.class, "Subscribe");
    }

    @Contract(value="null -> fail")
    @NotNull
    public static MqttSubscribe subscribe(@Nullable Mqtt3Subscribe subscribe) {
        return Checks.notImplemented(subscribe, Mqtt3SubscribeView.class, "Subscribe").getDelegate();
    }

    @Contract(value="null -> fail")
    @NotNull
    public static MqttUnsubscribe unsubscribe(@Nullable Mqtt5Unsubscribe unsubscribe) {
        return Checks.notImplemented(unsubscribe, MqttUnsubscribe.class, "Unsubscribe");
    }

    @Contract(value="null -> fail")
    @NotNull
    public static MqttUnsubscribe unsubscribe(@Nullable Mqtt3Unsubscribe unsubscribe) {
        return Checks.notImplemented(unsubscribe, Mqtt3UnsubscribeView.class, "Unsubscribe").getDelegate();
    }

    @Contract(value="null -> fail")
    @NotNull
    public static MqttDisconnect disconnect(@Nullable Mqtt5Disconnect disconnect) {
        return Checks.notImplemented(disconnect, MqttDisconnect.class, "Disconnect");
    }

    private MqttChecks() {
    }
}

