/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.rx.operators;

import com.hivemq.client.internal.rx.WithSingleConditionalSubscriber;
import com.hivemq.client.internal.rx.operators.FlowableWithSingleOperator;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.rx.FlowableWithSingle;
import com.hivemq.client.rx.FlowableWithSingleSubscriber;
import com.hivemq.client.rx.reactivestreams.WithSingleSubscriber;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class FlowableWithSingleMapError<F, S>
extends FlowableWithSingleOperator<F, S, F, S> {
    @NotNull
    private final Function<? super Throwable, ? extends Throwable> errorMapper;

    public FlowableWithSingleMapError(@NotNull FlowableWithSingle<F, S> source, @NotNull Function<? super Throwable, ? extends Throwable> errorMapper) {
        super(source);
        this.errorMapper = errorMapper;
    }

    protected void subscribeActual(@NotNull Subscriber<? super F> subscriber) {
        if (subscriber instanceof ConditionalSubscriber) {
            ConditionalSubscriber conditional = (ConditionalSubscriber)subscriber;
            this.source.subscribe(new MapErrorSubscriber.Conditional(conditional, this.errorMapper));
        } else {
            this.source.subscribe(new MapErrorSubscriber(subscriber, this.errorMapper));
        }
    }

    @Override
    protected void subscribeBothActual(@NotNull WithSingleSubscriber<? super F, ? super S> subscriber) {
        if (subscriber instanceof WithSingleConditionalSubscriber) {
            WithSingleConditionalSubscriber conditional = (WithSingleConditionalSubscriber)subscriber;
            this.source.subscribeBoth(new WithSingleMapErrorSubscriber.Conditional(conditional, this.errorMapper));
        } else {
            this.source.subscribeBoth(new WithSingleMapErrorSubscriber<F, S>(subscriber, this.errorMapper));
        }
    }

    private static class WithSingleMapErrorSubscriber<F, S>
    extends MapErrorSubscriber<F, WithSingleSubscriber<? super F, ? super S>>
    implements FlowableWithSingleSubscriber<F, S> {
        WithSingleMapErrorSubscriber(@NotNull WithSingleSubscriber<? super F, ? super S> subscriber, @NotNull Function<? super Throwable, ? extends Throwable> errorMapper) {
            super(subscriber, errorMapper);
        }

        @Override
        public void onSingle(@NotNull S s) {
            ((WithSingleSubscriber)this.subscriber).onSingle(s);
        }

        private static class Conditional<F, S>
        extends MapErrorSubscriber.Conditional<F, WithSingleConditionalSubscriber<? super F, ? super S>>
        implements WithSingleConditionalSubscriber<F, S> {
            Conditional(@NotNull WithSingleConditionalSubscriber<? super F, ? super S> subscriber, @NotNull Function<? super Throwable, ? extends Throwable> errorMapper) {
                super(subscriber, errorMapper);
            }

            @Override
            public void onSingle(@NotNull S s) {
                ((WithSingleConditionalSubscriber)this.subscriber).onSingle(s);
            }
        }
    }

    private static class MapErrorSubscriber<F, T extends Subscriber<? super F>>
    implements FlowableSubscriber<F>,
    Subscription {
        @NotNull
        final T subscriber;
        @NotNull
        private final Function<? super Throwable, ? extends Throwable> errorMapper;
        @Nullable
        private Subscription subscription;

        MapErrorSubscriber(@NotNull T subscriber, @NotNull Function<? super Throwable, ? extends Throwable> errorMapper) {
            this.subscriber = subscriber;
            this.errorMapper = errorMapper;
        }

        public void onSubscribe(@NotNull Subscription subscription) {
            this.subscription = subscription;
            this.subscriber.onSubscribe((Subscription)this);
        }

        public void onNext(@NotNull F f) {
            this.subscriber.onNext(f);
        }

        public void onError(@NotNull Throwable error) {
            Throwable em;
            try {
                em = (Throwable)Checks.notNull(this.errorMapper.apply((Object)error), "Mapped exception");
            }
            catch (Throwable throwable) {
                Exceptions.throwIfFatal((Throwable)throwable);
                em = new CompositeException(new Throwable[]{error, throwable});
            }
            this.subscriber.onError(em);
        }

        public void onComplete() {
            this.subscriber.onComplete();
        }

        public void request(long n) {
            assert (this.subscription != null);
            this.subscription.request(n);
        }

        public void cancel() {
            assert (this.subscription != null);
            this.subscription.cancel();
        }

        private static class Conditional<F, T extends ConditionalSubscriber<? super F>>
        extends MapErrorSubscriber<F, T>
        implements ConditionalSubscriber<F> {
            Conditional(@NotNull T subscriber, @NotNull Function<? super Throwable, ? extends Throwable> errorMapper) {
                super(subscriber, errorMapper);
            }

            public boolean tryOnNext(@NotNull F f) {
                return ((ConditionalSubscriber)this.subscriber).tryOnNext(f);
            }
        }
    }
}

