/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.util;

import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;

public abstract class AsyncRuntimeException
extends RuntimeException {
    private final boolean afterSuper;

    @NotNull
    public static RuntimeException fillInStackTrace(@NotNull RuntimeException e) {
        if (e instanceof AsyncRuntimeException) {
            e.fillInStackTrace();
        }
        return e;
    }

    protected AsyncRuntimeException() {
        this.afterSuper = true;
    }

    protected AsyncRuntimeException(@Nullable String message) {
        super(message, null);
        this.afterSuper = true;
    }

    protected AsyncRuntimeException(@Nullable String message, @Nullable Throwable cause) {
        super(message, cause);
        this.afterSuper = true;
    }

    protected AsyncRuntimeException(@Nullable Throwable cause) {
        super(cause);
        this.afterSuper = true;
    }

    @Override
    @NotNull
    public synchronized Throwable fillInStackTrace() {
        if (this.afterSuper) {
            return super.fillInStackTrace();
        }
        return this;
    }
}

