/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.util;

import com.hivemq.client.internal.annotations.NotThreadSafe;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;

@NotThreadSafe
public class Ranges {
    @NotNull
    private Range rootRange;

    public Ranges(int minId, int maxId) {
        this.rootRange = new Range(minId, maxId + 1);
    }

    public int getId() {
        return this.rootRange.getId();
    }

    public void returnId(int id) {
        this.rootRange = this.rootRange.returnId(id);
    }

    public int resize(int maxId) {
        Range range = this.rootRange;
        while (range.end <= maxId) {
            Range next = range.next;
            if (next == null) {
                range.end = maxId + 1;
                return 0;
            }
            range = next;
        }
        int count = range.start - (maxId + 1);
        if (count < 0) {
            count = 0;
        }
        while (range.next != null) {
            Range next = range.next;
            count += next.start - range.end;
            range = next;
        }
        if (count == 0) {
            range.end = maxId + 1;
        }
        return count;
    }

    private static class Range {
        int start;
        int end;
        @Nullable
        Range next;

        Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        Range(int start, int end, @NotNull Range next) {
            this.start = start;
            this.end = end;
            this.next = next;
        }

        int getId() {
            if (this.start == this.end) {
                return -1;
            }
            int id = this.start++;
            if (this.start == this.end && this.next != null) {
                this.start = this.next.start;
                this.end = this.next.end;
                this.next = this.next.next;
            }
            return id;
        }

        @NotNull
        Range returnId(int id) {
            Range range = this;
            if (id < this.start - 1) {
                range = new Range(id, id + 1, this);
            } else if (id == this.start - 1) {
                --this.start;
            } else {
                if (id < this.end) {
                    throw new IllegalStateException("The id was already returned. This must not happen and is a bug.");
                }
                if (id == this.end) {
                    if (this.next == null) {
                        throw new IllegalStateException("The id is greater than maxId. This must not happen and is a bug.");
                    }
                    ++this.end;
                    if (this.end == this.next.start) {
                        this.end = this.next.end;
                        this.next = this.next.next;
                    }
                } else if (this.next != null) {
                    this.next = this.next.returnId(id);
                } else {
                    throw new IllegalStateException("The id is greater than maxId. This must not happen and is a bug.");
                }
            }
            return range;
        }
    }
}

