/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.util.collections;

import com.hivemq.client.internal.annotations.NotThreadSafe;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;

@NotThreadSafe
public class ChunkedIntArrayQueue {
    private final int chunkSize;
    @NotNull
    private IntChunk producerChunk;
    @NotNull
    private IntChunk consumerChunk;
    private int producerIndex;
    private int consumerIndex;
    private int size;

    public ChunkedIntArrayQueue(int chunkSize) {
        this.chunkSize = chunkSize;
        this.producerChunk = this.consumerChunk = new IntChunk(chunkSize);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void offer(int value) {
        int newProducerIndex;
        IntChunk producerChunk = this.producerChunk;
        int producerIndex = this.producerIndex;
        int n = newProducerIndex = producerIndex == this.chunkSize ? 0 : producerIndex;
        if (this.size > 0 && (producerIndex == this.chunkSize && producerChunk != this.consumerChunk || producerChunk == this.consumerChunk && newProducerIndex == this.consumerIndex)) {
            IntChunk chunk = new IntChunk(this.chunkSize);
            producerChunk.jumpIndex = producerIndex - 1;
            producerChunk.next = chunk;
            producerChunk = chunk;
            this.producerChunk = chunk;
        }
        producerChunk.values[newProducerIndex] = value;
        this.producerIndex = newProducerIndex + 1;
        ++this.size;
    }

    public int poll(int nullValue) {
        if (this.size == 0) {
            return nullValue;
        }
        IntChunk consumerChunk = this.consumerChunk;
        int consumerIndex = this.consumerIndex;
        int value = consumerChunk.values[consumerIndex];
        --this.size;
        if (consumerIndex == consumerChunk.jumpIndex) {
            assert (consumerChunk.next != null);
            consumerIndex = 0;
            this.consumerChunk = consumerChunk.next;
        } else if (++consumerIndex == this.chunkSize) {
            consumerIndex = 0;
        }
        this.consumerIndex = consumerIndex;
        return value;
    }

    public int peek(int nullValue) {
        return this.size == 0 ? nullValue : this.consumerChunk.values[this.consumerIndex];
    }

    public void clear() {
        this.consumerChunk = this.producerChunk;
        this.producerIndex = 0;
        this.consumerIndex = 0;
    }

    public boolean removeFirst(int value) {
        IntChunk chunk = this.consumerChunk;
        int index = this.consumerIndex;
        for (int i = 0; i < this.size; ++i) {
            int currentValue = chunk.values[index];
            if (currentValue == value) {
                this.remove(chunk, index);
                return true;
            }
            if (index == chunk.jumpIndex) {
                assert (chunk.next != null);
                index = 0;
                chunk = chunk.next;
                continue;
            }
            if (++index != this.chunkSize) continue;
            index = 0;
        }
        return false;
    }

    private void remove(@NotNull IntChunk chunk, int index) {
        IntChunk currentChunk = this.consumerChunk;
        int currentIndex = this.consumerIndex;
        int lastValue = currentChunk.values[currentIndex];
        while (currentChunk != chunk || currentIndex != index) {
            if (currentIndex == currentChunk.jumpIndex) {
                assert (currentChunk.next != null);
                currentIndex = 0;
                currentChunk = currentChunk.next;
            } else if (++currentIndex == this.chunkSize) {
                currentIndex = 0;
            }
            int currentValue = currentChunk.values[currentIndex];
            currentChunk.values[currentIndex] = lastValue;
            lastValue = currentValue;
        }
        this.poll(-1);
    }

    private static class IntChunk {
        @NotNull
        final int[] values;
        int jumpIndex = -1;
        @Nullable
        IntChunk next;

        IntChunk(int chunkSize) {
            this.values = new int[chunkSize];
        }
    }
}

