/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.util.collections;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.internal.util.collections.ImmutableElement;
import com.hivemq.client.internal.util.collections.ImmutableEmptyList;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.shaded.org.jetbrains.annotations.Contract;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;

@Immutable
class ImmutableArray<E>
implements ImmutableList<E> {
    @NotNull
    private final @NotNull Object @NotNull [] array;

    @Contract(value="null -> fail")
    @NotNull
    static <E> ImmutableList<E> of(Object ... elements) {
        return ImmutableArray.of(elements, "Immutable list");
    }

    @Contract(value="null, _ -> fail")
    @NotNull
    static <E> ImmutableList<E> of(@Nullable @Nullable Object @Nullable [] elements, @NotNull String name) {
        return new ImmutableArray<E>(Checks.elementsNotNull(elements, name));
    }

    ImmutableArray(@NotNull @NotNull Object @NotNull [] array) {
        this.array = array;
        assert (this.size() > 1);
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    @NotNull
    public E get(int index) {
        return (E)this.array[Checks.index(index, this.array.length)];
    }

    @Override
    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        return (Object[])this.array.clone();
    }

    @Override
    public <T> T @NotNull [] toArray(T @NotNull [] other) {
        return ImmutableArray.toArray(this.array, 0, this.array.length, other);
    }

    private static <T> T @NotNull [] toArray(@NotNull @NotNull Object @NotNull [] array, int fromIndex, int length, T @NotNull [] other) {
        Checks.notNull(other, "Array");
        if (other.length < length) {
            other = (Object[])Array.newInstance(other.getClass().getComponentType(), length);
        } else if (other.length > length) {
            other[length] = null;
        }
        System.arraycopy(array, fromIndex, other, 0, length);
        return other;
    }

    @Override
    public int indexOf(@Nullable Object o) {
        if (o == null) {
            return -1;
        }
        for (int i = 0; i < this.array.length; ++i) {
            if (!o.equals(this.array[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(@Nullable Object o) {
        if (o == null) {
            return -1;
        }
        for (int i = this.array.length - 1; i >= 0; --i) {
            if (!o.equals(this.array[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    @NotNull
    public ImmutableList.ImmutableListIterator<E> listIterator(int index) {
        return new ArrayIterator(Checks.cursorIndex(index, this.array.length));
    }

    @Override
    @NotNull
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.array, 1296);
    }

    @Override
    public void forEach(@NotNull Consumer<? super E> consumer) {
        Checks.notNull(consumer, "Consumer");
        for (int i = 0; i < this.array.length; ++i) {
            consumer.accept(this.get(i));
        }
    }

    @Override
    @NotNull
    public ImmutableList<E> subList(int fromIndex, int toIndex) {
        Checks.indexRange(fromIndex, toIndex, this.array.length);
        int size = toIndex - fromIndex;
        switch (size) {
            case 0: {
                return ImmutableEmptyList.of();
            }
            case 1: {
                return new ImmutableElement<E>(this.get(fromIndex));
            }
        }
        return size == this.array.length ? this : new SubArray(fromIndex, toIndex);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        return ImmutableArray.equals(this.array, 0, this.array.length, (List)o);
    }

    private static boolean equals(@NotNull Object[] array, int fromIndex, int toIndex, @NotNull List<?> that) {
        if (toIndex - fromIndex != that.size()) {
            return false;
        }
        if (that instanceof RandomAccess) {
            for (int i = fromIndex; i < toIndex; ++i) {
                if (array[i].equals(that.get(i))) continue;
                return false;
            }
        } else {
            int i = fromIndex;
            for (Object e : that) {
                if (array[i++].equals(e)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        return ImmutableArray.hashCode(this.array, 0, this.array.length);
    }

    private static int hashCode(@NotNull Object[] array, int fromIndex, int toIndex) {
        int hashCode = 1;
        for (int i = fromIndex; i < toIndex; ++i) {
            hashCode = 31 * hashCode + array[i].hashCode();
        }
        return hashCode;
    }

    @NotNull
    public String toString() {
        return ImmutableArray.toString(this.array, 0, this.array.length);
    }

    @NotNull
    private static String toString(@NotNull Object[] array, int fromIndex, int toIndex) {
        StringBuilder sb = new StringBuilder().append('[');
        int i = fromIndex;
        while (true) {
            sb.append(array[i++]);
            if (i == toIndex) {
                return sb.append(']').toString();
            }
            sb.append(", ");
        }
    }

    private class ArrayIterator
    implements ImmutableList.ImmutableListIterator<E> {
        private final int fromIndex;
        private final int toIndex;
        private int index;

        private ArrayIterator(int index) {
            this.fromIndex = 0;
            this.toIndex = ImmutableArray.this.array.length;
            this.index = index;
        }

        private ArrayIterator(int fromIndex, int toIndex, int index) {
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.toIndex;
        }

        @Override
        @NotNull
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return ImmutableArray.this.get(this.index++);
        }

        @Override
        public boolean hasPrevious() {
            return this.index > this.fromIndex;
        }

        @Override
        @NotNull
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return ImmutableArray.this.get(--this.index);
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }
    }

    private class SubArray
    implements ImmutableList<E> {
        private final int fromIndex;
        private final int toIndex;

        SubArray(int fromIndex, int toIndex) {
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
            assert (this.size() > 1);
            assert (this.size() < ImmutableArray.this.size());
        }

        @Override
        public int size() {
            return this.toIndex - this.fromIndex;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        @NotNull
        public E get(int index) {
            return ImmutableArray.this.get(this.fromIndex + index);
        }

        @Override
        @NotNull
        public @NotNull Object @NotNull [] toArray() {
            return Arrays.copyOfRange(ImmutableArray.this.array, this.fromIndex, this.toIndex);
        }

        @Override
        public <T> T @NotNull [] toArray(T @NotNull [] other) {
            return ImmutableArray.toArray(ImmutableArray.this.array, this.fromIndex, this.size(), other);
        }

        @Override
        public int indexOf(@Nullable Object o) {
            if (o == null) {
                return -1;
            }
            for (int i = this.fromIndex; i < this.toIndex; ++i) {
                if (!o.equals(ImmutableArray.this.array[i])) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(@Nullable Object o) {
            if (o == null) {
                return -1;
            }
            for (int i = this.toIndex - 1; i >= this.fromIndex; --i) {
                if (!o.equals(ImmutableArray.this.array[i])) continue;
                return i;
            }
            return -1;
        }

        @Override
        @NotNull
        public ImmutableList.ImmutableListIterator<E> listIterator(int index) {
            return new ArrayIterator(this.fromIndex, this.toIndex, Checks.cursorIndex(index, this.size()));
        }

        @Override
        @NotNull
        public Spliterator<E> spliterator() {
            return Spliterators.spliterator(ImmutableArray.this.array, this.fromIndex, this.toIndex, 1296);
        }

        @Override
        public void forEach(@NotNull Consumer<? super E> consumer) {
            Checks.notNull(consumer, "Consumer");
            for (int i = this.fromIndex; i < this.toIndex; ++i) {
                consumer.accept(this.get(i));
            }
        }

        @Override
        @NotNull
        public ImmutableList<E> subList(int fromIndex, int toIndex) {
            return ImmutableArray.this.subList(this.fromIndex + fromIndex, this.fromIndex + toIndex);
        }

        @Override
        @NotNull
        public ImmutableList<E> trim() {
            return new ImmutableArray(this.toArray());
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            return ImmutableArray.equals(ImmutableArray.this.array, this.fromIndex, this.toIndex, (List)o);
        }

        @Override
        public int hashCode() {
            return ImmutableArray.hashCode(ImmutableArray.this.array, this.fromIndex, this.toIndex);
        }

        @NotNull
        public String toString() {
            return ImmutableArray.toString(ImmutableArray.this.array, this.fromIndex, this.toIndex);
        }
    }
}

