/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.util.collections;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.internal.util.collections.ImmutableArray;
import com.hivemq.client.internal.util.collections.ImmutableElement;
import com.hivemq.client.internal.util.collections.ImmutableEmptyList;
import com.hivemq.shaded.org.jetbrains.annotations.Contract;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

@Immutable
public interface ImmutableList<@NotNull E>
extends List<E>,
RandomAccess {
    @NotNull
    public static <E> ImmutableList<E> of() {
        return ImmutableEmptyList.of();
    }

    @Contract(value="null -> fail")
    @NotNull
    public static <E> ImmutableList<E> of(@Nullable E e) {
        return ImmutableElement.of(e);
    }

    @Contract(value="null, _ -> fail; _, null -> fail")
    @NotNull
    public static <E> ImmutableList<E> of(@Nullable E e1, @Nullable E e2) {
        return ImmutableArray.of(new Object[]{e1, e2});
    }

    @Contract(value="null, _, _ -> fail; _, null, _ -> fail; _, _, null -> fail")
    @NotNull
    public static <E> ImmutableList<E> of(@Nullable E e1, @Nullable E e2, @Nullable E e3) {
        return ImmutableArray.of(new Object[]{e1, e2, e3});
    }

    @SafeVarargs
    @Contract(value="null, _, _, _ -> fail; _, null, _, _ -> fail; _, _, null, _ -> fail; _, _, _, null -> fail")
    @NotNull
    public static <E> ImmutableList<E> of(@Nullable E e1, @Nullable E e2, @Nullable E e3, E ... others) {
        Checks.notNull(others, "Immutable list elements");
        Object[] array = new Object[3 + others.length];
        array[0] = e1;
        array[1] = e2;
        array[2] = e3;
        System.arraycopy(others, 0, array, 3, others.length);
        return ImmutableArray.of(array);
    }

    @Contract(value="null -> fail")
    @NotNull
    public static <E> ImmutableList<E> copyOf(@Nullable @Nullable E @Nullable [] elements) {
        return ImmutableList.copyOf(elements, "Immutable list");
    }

    @Contract(value="null, _ -> fail")
    @NotNull
    public static <E> ImmutableList<E> copyOf(@Nullable @Nullable E @Nullable [] elements, @NotNull String name) {
        Checks.notNull(elements, name);
        switch (elements.length) {
            case 0: {
                return ImmutableEmptyList.of();
            }
            case 1: {
                return ImmutableElement.of(elements[0], name);
            }
        }
        return ImmutableArray.of((Object[])Arrays.copyOf(elements, elements.length, Object[].class), name);
    }

    @Contract(value="null -> fail")
    @NotNull
    public static <E> ImmutableList<E> copyOf(@Nullable @Nullable Collection<@Nullable ? extends E> elements) {
        return ImmutableList.copyOf(elements, "Immutable list");
    }

    @Contract(value="null, _ -> fail")
    @NotNull
    public static <E> ImmutableList<E> copyOf(@Nullable @Nullable Collection<@Nullable ? extends E> elements, @NotNull String name) {
        Checks.notNull(elements, name);
        if (elements instanceof ImmutableList) {
            return ((ImmutableList)elements).trim();
        }
        switch (elements.size()) {
            case 0: {
                return ImmutableEmptyList.of();
            }
            case 1: {
                return ImmutableElement.of(Builder.first(elements), name);
            }
        }
        return ImmutableArray.of(elements.toArray(), name);
    }

    @NotNull
    public static <E> Builder<E> builder() {
        return new Builder();
    }

    @NotNull
    public static <E> Builder<E> builder(int capacity) {
        return new Builder(capacity);
    }

    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @NotNull
    public E get(int var1);

    @Override
    default public boolean contains(@Nullable Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    default public boolean containsAll(@NotNull Collection<?> c) {
        Checks.notNull(c, "Collection");
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    default public ImmutableListIterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    @NotNull
    default public ImmutableListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    @NotNull
    public ImmutableListIterator<E> listIterator(int var1);

    @Override
    @NotNull
    public ImmutableList<E> subList(int var1, int var2);

    @NotNull
    default public ImmutableList<E> trim() {
        return this;
    }

    @Override
    @Deprecated
    default public boolean add(@Nullable E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean remove(@Nullable Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean addAll(@NotNull Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean removeAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean removeIf(@NotNull Predicate<? super E> filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public void add(int index, @Nullable E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @Nullable
    default public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @Nullable
    default public E set(int index, @Nullable E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean addAll(int index, @NotNull Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public void replaceAll(@NotNull UnaryOperator<E> operator) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public void sort(Comparator<? super E> c) {
        throw new UnsupportedOperationException();
    }

    public static class Builder<E> {
        private static final int INITIAL_CAPACITY = 4;
        @Nullable
        private E e;
        private @NotNull Object @Nullable [] array;
        private int size;

        private Builder() {
        }

        private Builder(int capacity) {
            if (capacity > 1) {
                this.array = new Object[capacity];
            }
        }

        private int newCapacity(int capacity) {
            return capacity + (capacity >> 1);
        }

        @NotNull
        public Builder<E> add(@NotNull E e) {
            Checks.notNull(e, "Immutable list element");
            if (this.size == 0) {
                this.e = e;
                this.size = 1;
            } else {
                if (this.array == null) {
                    this.array = new Object[4];
                } else if (this.size == this.array.length) {
                    this.array = Arrays.copyOf(this.array, this.newCapacity(this.array.length), Object[].class);
                }
                if (this.e != null) {
                    this.array[0] = this.e;
                    this.e = null;
                }
                this.array[this.size++] = e;
            }
            return this;
        }

        @NotNull
        public Builder<E> addAll(@NotNull @NotNull Collection<@NotNull ? extends E> elements) {
            Checks.notNull(elements, "Immutable list elements");
            int elementsSize = elements.size();
            switch (elementsSize) {
                case 0: {
                    break;
                }
                case 1: {
                    this.add(Builder.first(elements));
                    break;
                }
                default: {
                    int newSize = this.size + elementsSize;
                    if (this.array == null) {
                        this.array = new Object[Math.max(4, newSize)];
                    } else if (newSize > this.array.length) {
                        this.array = Arrays.copyOf(this.array, Math.max(this.newCapacity(this.array.length), newSize), Object[].class);
                    }
                    if (this.e != null) {
                        this.array[0] = this.e;
                        this.e = null;
                    }
                    if (elements instanceof List && elements instanceof RandomAccess) {
                        List list = (List)elements;
                        for (int i = 0; i < elementsSize; ++i) {
                            this.array[this.size + i] = Checks.notNull(list.get(i), "Immutable list");
                        }
                    } else {
                        int i = this.size;
                        for (E e : elements) {
                            this.array[i++] = Checks.notNull(e, "Immutable list");
                        }
                    }
                    this.size = newSize;
                }
            }
            return this;
        }

        @NotNull
        public ImmutableList<E> build() {
            switch (this.size) {
                case 0: {
                    return ImmutableEmptyList.of();
                }
                case 1: {
                    assert (this.e != null);
                    return new ImmutableElement<E>(this.e);
                }
            }
            assert (this.array != null);
            if (this.array.length == this.size) {
                return new ImmutableArray(this.array);
            }
            return new ImmutableArray(Arrays.copyOfRange(this.array, 0, this.size, Object[].class));
        }

        @NotNull
        static <E> E first(@NotNull @NotNull Collection<@NotNull E> elements) {
            return elements instanceof List ? ((List)elements).get(0) : elements.iterator().next();
        }
    }

    public static interface ImmutableListIterator<E>
    extends ListIterator<E> {
        @Override
        @Deprecated
        default public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        default public void set(@Nullable E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        default public void add(@Nullable E e) {
            throw new UnsupportedOperationException();
        }
    }
}

