/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.util.collections;

import com.hivemq.client.internal.annotations.NotThreadSafe;
import com.hivemq.client.internal.util.Pow2Util;
import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;

@NotThreadSafe
public abstract class IntMap<E> {
    private static final int ONE_LEVEL_CAPACITY_BITS = 7;
    private static final int TWO_LEVEL_CAPACITY_BITS = 12;
    private static final int THREE_LEVEL_CAPACITY_BITS = 18;

    @NotNull
    public static <E> IntMap<E> range(int minKey, int maxKey) {
        int capacity = maxKey - minKey + 1;
        int capacityBits = Pow2Util.roundToPowerOf2Bits(capacity);
        return IntMap.create(capacity, capacityBits, minKey, maxKey);
    }

    @NotNull
    public static <E> IntMap<E> resize(@NotNull IntMap<E> oldMap, int newMaxKey) {
        int oldCapacity;
        int oldCapacityBits;
        int oldMaxKey = oldMap.getMaxKey();
        if (oldMaxKey == newMaxKey) {
            return oldMap;
        }
        int minKey = oldMap.getMinKey();
        int newCapacity = newMaxKey - minKey + 1;
        int newCapacityBits = Pow2Util.roundToPowerOf2Bits(newCapacity);
        if (newCapacityBits > 7 && oldMap instanceof IntMapCheck && (oldCapacityBits = Pow2Util.roundToPowerOf2Bits(oldCapacity = oldMaxKey - minKey + 1)) == newCapacityBits) {
            return new IntMapCheck(((IntMapCheck)oldMap).delegate, minKey, newMaxKey);
        }
        IntMap newMap = IntMap.create(newCapacity, newCapacityBits, minKey, newMaxKey);
        oldMap.forEach((key, value) -> {
            if (key > newMaxKey) {
                return false;
            }
            newMap.put(key, value);
            return true;
        });
        return newMap;
    }

    @NotNull
    private static <E> IntMap<E> create(int capacity, int capacityBits, int minKey, int maxKey) {
        IntMap intMap = capacityBits <= 7 ? new IntMapArray(capacity) : (capacityBits <= 12 ? new IntMapAllocator(capacityBits, 2).alloc() : (capacityBits <= 18 ? new IntMapAllocator(capacityBits, 3).alloc() : new IntMapAllocator(capacityBits, 4).alloc()));
        return new IntMapCheck(intMap, minKey, maxKey);
    }

    @Nullable
    public abstract E put(int var1, @NotNull E var2);

    @Nullable
    public abstract E get(int var1);

    @Nullable
    public abstract E remove(int var1);

    public abstract int size();

    public abstract int getMinKey();

    public abstract int getMaxKey();

    public abstract void clear();

    public void forEach(@NotNull IntMapConsumer<E> consumer) {
        this.forEach(consumer, 0);
    }

    abstract boolean forEach(@NotNull IntMapConsumer<E> var1, int var2);

    public static class IntMapLevel<E>
    extends IntMap<E> {
        private final int shift;
        private final int mask;
        private final @Nullable IntMap<E> @NotNull [] subLevels;
        @NotNull
        private final IntMapAllocator<E> allocator;
        private int size;

        IntMapLevel(int shift, int mask, int indexCapacity, @NotNull IntMapAllocator<E> allocator) {
            this.shift = shift;
            this.mask = mask;
            this.subLevels = new IntMap[indexCapacity];
            this.allocator = allocator;
        }

        @Override
        @Nullable
        public E put(int key, @NotNull E value) {
            E put;
            int index = key >> this.shift;
            IntMap<E> subLevel = this.subLevels[index];
            if (subLevel == null) {
                subLevel = this.allocator.alloc();
                this.subLevels[index] = subLevel;
            }
            if ((put = subLevel.put(key & this.mask, value)) == null) {
                ++this.size;
            }
            return put;
        }

        @Override
        @Nullable
        public E get(int key) {
            IntMap<E> subLevel = this.subLevels[key >> this.shift];
            if (subLevel == null) {
                return null;
            }
            return subLevel.get(key & this.mask);
        }

        @Override
        @Nullable
        public E remove(int key) {
            int index = key >> this.shift;
            IntMap<E> subLevel = this.subLevels[index];
            if (subLevel == null) {
                return null;
            }
            E value = subLevel.remove(key & this.mask);
            if (value != null) {
                --this.size;
                if (subLevel.size() == 0) {
                    this.allocator.free(subLevel);
                    this.subLevels[index] = null;
                }
            }
            return value;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public int getMinKey() {
            return 0;
        }

        @Override
        public int getMaxKey() {
            return this.subLevels.length - 1 << this.shift;
        }

        @Override
        public void clear() {
            int cleared = 0;
            for (int i = 0; i < this.subLevels.length; ++i) {
                IntMap<E> subLevel = this.subLevels[i];
                if (subLevel == null) continue;
                subLevel.clear();
                this.subLevels[i] = null;
                if ((cleared += subLevel.size()) == this.size) break;
            }
            this.size = 0;
        }

        @Override
        boolean forEach(@NotNull IntMapConsumer<E> consumer, int baseIndex) {
            int emitted = 0;
            for (IntMap<E> subLevel : this.subLevels) {
                if (subLevel != null) {
                    if (!subLevel.forEach(consumer, baseIndex)) {
                        return false;
                    }
                    if ((emitted += subLevel.size()) == this.size) break;
                }
                baseIndex += this.mask + 1;
            }
            return true;
        }
    }

    private static class IntMapAllocator<E> {
        private final int shift;
        private final int mask;
        private final int indexCapacity;
        @Nullable
        private final IntMapAllocator<E> next;
        @Nullable
        private IntMap<E> free;

        IntMapAllocator(int capacityBits, int split) {
            if (split == 1) {
                this.shift = -1;
                this.mask = -1;
                this.indexCapacity = 1 << capacityBits;
                this.next = null;
            } else {
                int indexBits = capacityBits / split;
                this.shift = capacityBits - indexBits;
                this.mask = (1 << this.shift) - 1;
                this.indexCapacity = 1 << indexBits;
                this.next = new IntMapAllocator<E>(capacityBits - indexBits, split - 1);
            }
        }

        @NotNull
        IntMap<E> alloc() {
            if (this.free != null) {
                IntMap<E> allocated = this.free;
                this.free = null;
                return allocated;
            }
            if (this.next == null) {
                return new IntMapArray(this.indexCapacity);
            }
            return new IntMapLevel<E>(this.shift, this.mask, this.indexCapacity, this.next);
        }

        void free(@NotNull IntMap<E> intMap) {
            this.free = intMap;
        }
    }

    public static class IntMapArray<E>
    extends IntMap<E> {
        private final @Nullable E @NotNull [] values;
        private int size;

        IntMapArray(int size) {
            this.values = new Object[size];
        }

        @Override
        @Nullable
        public E put(int key, @NotNull E value) {
            E previousValue = this.values[key];
            this.values[key] = value;
            if (previousValue == null) {
                ++this.size;
            }
            return previousValue;
        }

        @Override
        @Nullable
        public E get(int key) {
            return this.values[key];
        }

        @Override
        @Nullable
        public E remove(int key) {
            E previousValue = this.values[key];
            this.values[key] = null;
            if (previousValue != null) {
                --this.size;
            }
            return previousValue;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public int getMinKey() {
            return 0;
        }

        @Override
        public int getMaxKey() {
            return this.values.length - 1;
        }

        @Override
        public void clear() {
            int emitted = 0;
            for (int index = 0; index < this.values.length; ++index) {
                E value = this.values[index];
                if (value == null) continue;
                this.values[index] = null;
                if (++emitted == this.size) break;
            }
            this.size = 0;
        }

        @Override
        boolean forEach(@NotNull IntMapConsumer<E> consumer, int baseIndex) {
            int emitted = 0;
            for (int index = 0; index < this.values.length; ++index) {
                E value = this.values[index];
                if (value == null) continue;
                if (!consumer.accept(baseIndex + index, value)) {
                    return false;
                }
                if (++emitted == this.size) break;
            }
            return true;
        }
    }

    public static class IntMapCheck<E>
    extends IntMap<E> {
        @NotNull
        private final IntMap<E> delegate;
        private final int minKey;
        private final int maxKey;

        IntMapCheck(@NotNull IntMap<E> delegate, int minKey, int maxKey) {
            this.delegate = delegate;
            this.minKey = minKey;
            this.maxKey = maxKey;
        }

        @Override
        @Nullable
        public E put(int key, @NotNull E value) {
            return this.delegate.put(this.checkKey(key), value);
        }

        @Override
        @Nullable
        public E get(int key) {
            return this.delegate.get(this.checkKey(key));
        }

        @Override
        @Nullable
        public E remove(int key) {
            return this.delegate.remove(this.checkKey(key));
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public int getMinKey() {
            return this.minKey;
        }

        @Override
        public int getMaxKey() {
            return this.maxKey;
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public void forEach(@NotNull IntMapConsumer<E> consumer) {
            this.delegate.forEach(consumer, this.minKey);
        }

        @Override
        boolean forEach(@NotNull IntMapConsumer<E> consumer, int baseIndex) {
            return this.delegate.forEach(consumer, this.minKey);
        }

        private int checkKey(int key) {
            if (key > this.maxKey || key < this.minKey) {
                throw new IndexOutOfBoundsException();
            }
            return key - this.minKey;
        }
    }

    public static interface IntMapConsumer<E> {
        public boolean accept(int var1, @NotNull E var2);
    }
}

