/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.util;

import com.hivemq.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.shaded.org.jetbrains.annotations.Nullable;
import java.util.function.Consumer;

public interface TypeSwitch<T> {
    @NotNull
    public static <T> TypeSwitch<T> never() {
        return Never.INSTANCE;
    }

    @NotNull
    public static <T> TypeSwitch<T> when(@Nullable T t) {
        return t == null ? TypeSwitch.never() : new Default<T>(t);
    }

    @NotNull
    public <I extends T> TypeSwitch<T> is(@NotNull Class<I> var1, @NotNull Consumer<I> var2);

    public static class Never
    implements TypeSwitch<Object> {
        @NotNull
        static final Never INSTANCE = new Never();

        private Never() {
        }

        @NotNull
        public <I> Never is(@NotNull Class<I> type, @NotNull Consumer<I> consumer) {
            return this;
        }
    }

    public static class Default<T>
    implements TypeSwitch<T> {
        @Nullable
        private final T t;

        Default(@Nullable T t) {
            this.t = t;
        }

        @Override
        @NotNull
        public <I extends T> TypeSwitch<T> is(@NotNull Class<I> type, @NotNull Consumer<I> consumer) {
            if (type.isInstance(this.t)) {
                consumer.accept(this.t);
                return TypeSwitch.never();
            }
            return this;
        }
    }
}

