/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt;

import com.hivemq.client.internal.mqtt.MqttClientSslConfigImplBuilder;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.client.mqtt.MqttClientSslConfig;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;

public class MqttClientSslConfigImpl
implements MqttClientSslConfig {
    @Nullable
    static final HostnameVerifier DEFAULT_HOSTNAME_VERIFIER;
    @NotNull
    static final MqttClientSslConfigImpl DEFAULT;
    @Nullable
    private final KeyManagerFactory keyManagerFactory;
    @Nullable
    private final TrustManagerFactory trustManagerFactory;
    @Nullable
    private final ImmutableList<String> cipherSuites;
    @Nullable
    private final ImmutableList<String> protocols;
    private final int handshakeTimeoutMs;
    @Nullable
    private final HostnameVerifier hostnameVerifier;

    MqttClientSslConfigImpl(@Nullable KeyManagerFactory keyManagerFactory, @Nullable TrustManagerFactory trustManagerFactory, @Nullable ImmutableList<String> cipherSuites, @Nullable ImmutableList<String> protocols, int handshakeTimeoutMs, @Nullable HostnameVerifier hostnameVerifier) {
        this.keyManagerFactory = keyManagerFactory;
        this.trustManagerFactory = trustManagerFactory;
        this.cipherSuites = cipherSuites;
        this.protocols = protocols;
        this.handshakeTimeoutMs = handshakeTimeoutMs;
        this.hostnameVerifier = hostnameVerifier;
    }

    @Override
    @NotNull
    public Optional<KeyManagerFactory> getKeyManagerFactory() {
        return Optional.ofNullable(this.keyManagerFactory);
    }

    @Nullable
    public KeyManagerFactory getRawKeyManagerFactory() {
        return this.keyManagerFactory;
    }

    @Override
    @NotNull
    public Optional<TrustManagerFactory> getTrustManagerFactory() {
        return Optional.ofNullable(this.trustManagerFactory);
    }

    @Nullable
    public TrustManagerFactory getRawTrustManagerFactory() {
        return this.trustManagerFactory;
    }

    @Override
    @NotNull
    public Optional<List<String>> getCipherSuites() {
        return Optional.ofNullable(this.cipherSuites);
    }

    @Nullable
    public ImmutableList<String> getRawCipherSuites() {
        return this.cipherSuites;
    }

    @Override
    @NotNull
    public Optional<List<String>> getProtocols() {
        return Optional.ofNullable(this.protocols);
    }

    @Nullable
    public ImmutableList<String> getRawProtocols() {
        return this.protocols;
    }

    @Override
    public long getHandshakeTimeoutMs() {
        return this.handshakeTimeoutMs;
    }

    @Override
    @NotNull
    public Optional<HostnameVerifier> getHostnameVerifier() {
        return Optional.ofNullable(this.hostnameVerifier);
    }

    @Nullable
    public HostnameVerifier getRawHostnameVerifier() {
        return this.hostnameVerifier;
    }

    @Override
    public @NotNull MqttClientSslConfigImplBuilder.Default extend() {
        return new MqttClientSslConfigImplBuilder.Default(this);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MqttClientSslConfigImpl)) {
            return false;
        }
        MqttClientSslConfigImpl that = (MqttClientSslConfigImpl)o;
        return Objects.equals(this.keyManagerFactory, that.keyManagerFactory) && Objects.equals(this.trustManagerFactory, that.trustManagerFactory) && Objects.equals(this.cipherSuites, that.cipherSuites) && Objects.equals(this.protocols, that.protocols) && this.handshakeTimeoutMs == that.handshakeTimeoutMs && Objects.equals(this.hostnameVerifier, that.hostnameVerifier);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.keyManagerFactory);
        result = 31 * result + Objects.hashCode(this.trustManagerFactory);
        result = 31 * result + Objects.hashCode(this.cipherSuites);
        result = 31 * result + Objects.hashCode(this.protocols);
        result = 31 * result + Integer.hashCode(this.handshakeTimeoutMs);
        result = 31 * result + Objects.hashCode(this.hostnameVerifier);
        return result;
    }

    static {
        HostnameVerifier hostnameVerifier = null;
        try {
            new SSLParameters().setEndpointIdentificationAlgorithm("HTTPS");
        }
        catch (NoSuchMethodError e) {
            hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
        }
        DEFAULT_HOSTNAME_VERIFIER = hostnameVerifier;
        DEFAULT = new MqttClientSslConfigImpl(null, null, null, null, 10000, DEFAULT_HOSTNAME_VERIFIER);
    }
}

