/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt;

import com.hivemq.client.internal.mqtt.MqttClientSslConfigImpl;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.client.mqtt.MqttClientSslConfigBuilder;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public abstract class MqttClientSslConfigImplBuilder<B extends MqttClientSslConfigImplBuilder<B>> {
    @Nullable
    private KeyManagerFactory keyManagerFactory;
    @Nullable
    private TrustManagerFactory trustManagerFactory;
    @Nullable
    private ImmutableList<String> cipherSuites;
    @Nullable
    private ImmutableList<String> protocols;
    private int handshakeTimeoutMs = 10000;
    @Nullable
    private HostnameVerifier hostnameVerifier = MqttClientSslConfigImpl.DEFAULT_HOSTNAME_VERIFIER;

    MqttClientSslConfigImplBuilder() {
    }

    MqttClientSslConfigImplBuilder(@Nullable MqttClientSslConfigImpl sslConfig) {
        if (sslConfig != null) {
            this.keyManagerFactory = sslConfig.getRawKeyManagerFactory();
            this.trustManagerFactory = sslConfig.getRawTrustManagerFactory();
            this.cipherSuites = sslConfig.getRawCipherSuites();
            this.protocols = sslConfig.getRawProtocols();
            this.handshakeTimeoutMs = (int)sslConfig.getHandshakeTimeoutMs();
            this.hostnameVerifier = sslConfig.getRawHostnameVerifier();
        }
    }

    @NotNull
    abstract B self();

    @NotNull
    public B keyManagerFactory(@Nullable KeyManagerFactory keyManagerFactory) {
        this.keyManagerFactory = keyManagerFactory;
        return this.self();
    }

    @NotNull
    public B trustManagerFactory(@Nullable TrustManagerFactory trustManagerFactory) {
        this.trustManagerFactory = trustManagerFactory;
        return this.self();
    }

    @NotNull
    public B cipherSuites(@Nullable @Nullable Collection<@Nullable String> cipherSuites) {
        this.cipherSuites = cipherSuites == null ? null : ImmutableList.copyOf(cipherSuites, "Cipher suites");
        return this.self();
    }

    @NotNull
    public B protocols(@Nullable @Nullable Collection<@Nullable String> protocols) {
        this.protocols = protocols == null ? null : ImmutableList.copyOf(protocols, "Protocols");
        return this.self();
    }

    @NotNull
    public B handshakeTimeout(long timeout, @Nullable TimeUnit timeUnit) {
        Checks.notNull(timeUnit, "Time unit");
        this.handshakeTimeoutMs = (int)Checks.range(timeUnit.toMillis(timeout), 0L, Integer.MAX_VALUE, "Handshake timeout in milliseconds");
        return this.self();
    }

    @NotNull
    public B hostnameVerifier(@Nullable HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier == null ? MqttClientSslConfigImpl.DEFAULT_HOSTNAME_VERIFIER : hostnameVerifier;
        return this.self();
    }

    @NotNull
    public MqttClientSslConfigImpl build() {
        return new MqttClientSslConfigImpl(this.keyManagerFactory, this.trustManagerFactory, this.cipherSuites, this.protocols, this.handshakeTimeoutMs, this.hostnameVerifier);
    }

    public static class Nested<P>
    extends MqttClientSslConfigImplBuilder<Nested<P>>
    implements MqttClientSslConfigBuilder.Nested<P> {
        @NotNull
        private final Function<? super MqttClientSslConfigImpl, P> parentConsumer;

        Nested(@Nullable MqttClientSslConfigImpl sslConfig, @NotNull Function<? super MqttClientSslConfigImpl, P> parentConsumer) {
            super(sslConfig);
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Nested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applySslConfig() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Default
    extends MqttClientSslConfigImplBuilder<Default>
    implements MqttClientSslConfigBuilder {
        public Default() {
        }

        Default(@Nullable MqttClientSslConfigImpl sslConfig) {
            super(sslConfig);
        }

        @Override
        @NotNull
        Default self() {
            return this;
        }
    }
}

