/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt;

import com.hivemq.client.internal.mqtt.MqttProxyConfigImplBuilder;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.mqtt.MqttProxyConfig;
import com.hivemq.client.mqtt.MqttProxyProtocol;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.Optional;

public class MqttProxyConfigImpl
implements MqttProxyConfig {
    @NotNull
    private final MqttProxyProtocol protocol;
    @NotNull
    private final InetSocketAddress address;
    @Nullable
    private final String username;
    @Nullable
    private final String password;
    private final int handshakeTimeoutMs;

    MqttProxyConfigImpl(@NotNull MqttProxyProtocol protocol, @NotNull InetSocketAddress address, @Nullable String username, @Nullable String password, int handshakeTimeoutMs) {
        this.protocol = protocol;
        this.address = address;
        this.username = username;
        this.password = password;
        this.handshakeTimeoutMs = handshakeTimeoutMs;
    }

    @Override
    @NotNull
    public MqttProxyProtocol getProtocol() {
        return this.protocol;
    }

    @Override
    @NotNull
    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    @NotNull
    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    @Nullable
    public String getRawUsername() {
        return this.username;
    }

    @Override
    @NotNull
    public Optional<String> getPassword() {
        return Optional.ofNullable(this.password);
    }

    @Nullable
    public String getRawPassword() {
        return this.password;
    }

    @Override
    public int getHandshakeTimeoutMs() {
        return this.handshakeTimeoutMs;
    }

    @Override
    public @NotNull MqttProxyConfigImplBuilder.Default extend() {
        return new MqttProxyConfigImplBuilder.Default(this);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MqttProxyConfigImpl)) {
            return false;
        }
        MqttProxyConfigImpl that = (MqttProxyConfigImpl)o;
        return this.protocol == that.protocol && this.address.equals(that.address) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && this.handshakeTimeoutMs == that.handshakeTimeoutMs;
    }

    public int hashCode() {
        int result = this.protocol.hashCode();
        result = 31 * result + this.address.hashCode();
        result = 31 * result + Objects.hashCode(this.username);
        result = 31 * result + Objects.hashCode(this.password);
        result = 31 * result + Integer.hashCode(this.handshakeTimeoutMs);
        return result;
    }
}

