/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt;

import com.hivemq.client.internal.mqtt.MqttWebSocketConfigImpl;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.MqttWebSocketConfigBuilder;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public abstract class MqttWebSocketConfigImplBuilder<B extends MqttWebSocketConfigImplBuilder<B>> {
    @NotNull
    private String serverPath = "";
    @NotNull
    private String queryString = "";
    @NotNull
    private String subprotocol = "mqtt";
    private int handshakeTimeoutMs = 10000;
    @NotNull
    private Map<String, String> httpHeaders = MqttWebSocketConfigImpl.DEFAULT_HTTP_HEADERS;

    MqttWebSocketConfigImplBuilder() {
    }

    MqttWebSocketConfigImplBuilder(@Nullable MqttWebSocketConfigImpl webSocketConfig) {
        if (webSocketConfig != null) {
            this.serverPath = webSocketConfig.getServerPath();
            this.queryString = webSocketConfig.getQueryString();
            this.subprotocol = webSocketConfig.getSubprotocol();
            this.handshakeTimeoutMs = webSocketConfig.getHandshakeTimeoutMs();
        }
    }

    @NotNull
    abstract B self();

    @NotNull
    public B serverPath(@Nullable String serverPath) {
        this.serverPath = Checks.notNull(serverPath, "Server path").replaceAll("^/+", "");
        return this.self();
    }

    @NotNull
    public B queryString(@Nullable String queryString) {
        this.queryString = Checks.notNull(queryString, "Query string");
        return this.self();
    }

    @NotNull
    public B subprotocol(@Nullable String subprotocol) {
        this.subprotocol = Checks.notNull(subprotocol, "Subprotocol");
        return this.self();
    }

    @NotNull
    public B handshakeTimeout(long timeout, @Nullable TimeUnit timeUnit) {
        Checks.notNull(timeUnit, "Time unit");
        this.handshakeTimeoutMs = (int)Checks.range(timeUnit.toMillis(timeout), 0L, Integer.MAX_VALUE, "Handshake timeout in milliseconds");
        return this.self();
    }

    @NotNull
    public B httpHeaders(@Nullable Map<String, String> httpHeaders) {
        Checks.notNull(httpHeaders, "Http headers");
        this.httpHeaders = httpHeaders;
        return this.self();
    }

    @NotNull
    public MqttWebSocketConfigImpl build() {
        return new MqttWebSocketConfigImpl(this.serverPath, this.queryString, this.subprotocol, this.handshakeTimeoutMs, this.httpHeaders);
    }

    public static class Nested<P>
    extends MqttWebSocketConfigImplBuilder<Nested<P>>
    implements MqttWebSocketConfigBuilder.Nested<P> {
        @NotNull
        private final Function<? super MqttWebSocketConfigImpl, P> parentConsumer;

        Nested(@Nullable MqttWebSocketConfigImpl webSocketConfig, @NotNull Function<? super MqttWebSocketConfigImpl, P> parentConsumer) {
            super(webSocketConfig);
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Nested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applyWebSocketConfig() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Default
    extends MqttWebSocketConfigImplBuilder<Default>
    implements MqttWebSocketConfigBuilder {
        public Default() {
        }

        Default(@Nullable MqttWebSocketConfigImpl webSocketConfig) {
            super(webSocketConfig);
        }

        @Override
        @NotNull
        Default self() {
            return this;
        }
    }
}

