/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.encoder;

import com.hivemq.client.internal.mqtt.datatypes.MqttBinaryData;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttVariableByteInteger;
import com.hivemq.client.internal.mqtt.message.MqttMessage;
import com.hivemq.client.internal.shaded.io.netty.buffer.ByteBuf;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.mqtt.exceptions.MqttEncodeException;
import java.nio.ByteBuffer;

public final class MqttMessageEncoderUtil {
    public static int encodedPacketLength(int remainingLength) {
        return 1 + MqttMessageEncoderUtil.encodedLengthWithHeader(remainingLength);
    }

    public static int encodedLengthWithHeader(int encodedLength) {
        return MqttVariableByteInteger.encodedLength(encodedLength) + encodedLength;
    }

    public static int nullableEncodedLength(@Nullable MqttUtf8StringImpl string) {
        return string == null ? 0 : string.encodedLength();
    }

    public static int nullableEncodedLength(@Nullable ByteBuffer byteBuffer) {
        return byteBuffer == null ? 0 : MqttBinaryData.encodedLength(byteBuffer);
    }

    public static int encodedOrEmptyLength(@Nullable ByteBuffer byteBuffer) {
        return byteBuffer == null ? 2 : MqttBinaryData.encodedLength(byteBuffer);
    }

    public static void encodeNullable(@Nullable MqttUtf8StringImpl string, @NotNull ByteBuf out) {
        if (string != null) {
            string.encode(out);
        }
    }

    public static void encodeNullable(@Nullable ByteBuffer byteBuffer, @NotNull ByteBuf out) {
        if (byteBuffer != null) {
            MqttBinaryData.encode(byteBuffer, out);
        }
    }

    public static void encodeOrEmpty(@Nullable ByteBuffer byteBuffer, @NotNull ByteBuf out) {
        if (byteBuffer != null) {
            MqttBinaryData.encode(byteBuffer, out);
        } else {
            MqttBinaryData.encodeEmpty(out);
        }
    }

    @NotNull
    public static MqttEncodeException maximumPacketSizeExceeded(@NotNull MqttMessage message, int encodedLength, int maxPacketSize) {
        return new MqttEncodeException((Object)((Object)message.getType()) + " exceeded maximum packet size, minimal possible encoded length: " + encodedLength + ", maximum: " + maxPacketSize + ".");
    }

    private MqttMessageEncoderUtil() {
    }
}

