/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.datatypes;

import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImpl;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.ByteArray;
import java.util.Arrays;

public class MqttTopicLevel
extends ByteArray {
    @NotNull
    private static final MqttTopicLevel SINGLE_LEVEL_WILDCARD = new MqttTopicLevel(new byte[]{43});

    @NotNull
    static MqttTopicLevel of(byte @NotNull [] array, int start, int end) {
        if (MqttTopicLevel.isSingleLevelWildcard(array, start, end)) {
            return SINGLE_LEVEL_WILDCARD;
        }
        return new MqttTopicLevel(Arrays.copyOfRange(array, start, end));
    }

    private static boolean isSingleLevelWildcard(byte @NotNull [] array, int start, int end) {
        return end - start == 1 && array[start] == 43;
    }

    MqttTopicLevel(byte @NotNull [] array) {
        super(array);
    }

    byte @NotNull [] getArray() {
        return this.array;
    }

    public boolean isSingleLevelWildcard() {
        return MqttTopicLevel.isSingleLevelWildcard(this.array, this.getStart(), this.getEnd());
    }

    @NotNull
    public MqttTopicLevel trim() {
        return this;
    }

    @Nullable
    public static MqttTopicFilterImpl toFilter(byte @Nullable [] prefix, @Nullable MqttTopicLevel topicLevel, boolean multiLevelWildcard) {
        int length = 0;
        if (prefix != null) {
            length += prefix.length + 1;
        }
        if (topicLevel != null) {
            length += topicLevel.array.length;
        }
        if (multiLevelWildcard) {
            if (topicLevel != null) {
                ++length;
            }
            ++length;
        }
        byte[] bytes = new byte[length];
        int cursor = 0;
        if (prefix != null) {
            System.arraycopy(prefix, 0, bytes, cursor, prefix.length);
            bytes[cursor += prefix.length] = 47;
            ++cursor;
        }
        if (topicLevel != null) {
            System.arraycopy(topicLevel.array, 0, bytes, cursor, topicLevel.array.length);
            cursor += topicLevel.array.length;
        }
        if (multiLevelWildcard) {
            if (topicLevel != null) {
                bytes[cursor] = 47;
                ++cursor;
            }
            bytes[cursor] = 35;
        }
        return MqttTopicFilterImpl.of(bytes);
    }
}

