/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.publish.incoming;

import com.hivemq.client.internal.annotations.NotThreadSafe;
import com.hivemq.client.internal.mqtt.handler.publish.incoming.MqttIncomingPublishFlow;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.mqtt.message.publish.MqttStatefulPublish;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.util.collections.HandleList;
import com.hivemq.client.mqtt.datatypes.MqttQos;

@NotThreadSafe
class MqttStatefulPublishWithFlows
extends HandleList<MqttIncomingPublishFlow> {
    @NotNull
    final MqttStatefulPublish publish;
    long id;
    long connectionIndex;
    boolean subscriptionFound;
    private int missingAcknowledgements;

    MqttStatefulPublishWithFlows(@NotNull MqttStatefulPublish publish) {
        this.publish = publish;
    }

    @Override
    @NotNull
    public HandleList.Handle<MqttIncomingPublishFlow> add(@NotNull MqttIncomingPublishFlow flow) {
        if (((MqttPublish)this.publish.stateless()).getQos() != MqttQos.AT_MOST_ONCE && flow.manualAcknowledgement) {
            ++this.missingAcknowledgements;
            flow.increaseMissingAcknowledgements();
        }
        return super.add(flow);
    }

    boolean areAcknowledged() {
        return this.missingAcknowledgements == 0;
    }

    void acknowledge(@NotNull MqttIncomingPublishFlow flow) {
        flow.acknowledge(--this.missingAcknowledgements == 0);
    }
}

