/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.websocket;

import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.MqttClientTransportConfigImpl;
import com.hivemq.client.internal.mqtt.MqttWebSocketConfigImpl;
import com.hivemq.client.internal.mqtt.handler.websocket.MqttWebSocketCodec;
import com.hivemq.client.internal.mqtt.handler.websocket.MqttWebSocketHttpHeaders;
import com.hivemq.client.internal.mqtt.handler.websocket.MqttWebsocketHandshakeHandler;
import com.hivemq.client.internal.mqtt.ioc.ConnectionScope;
import com.hivemq.client.internal.shaded.io.netty.channel.Channel;
import com.hivemq.client.internal.shaded.io.netty.channel.ChannelHandler;
import com.hivemq.client.internal.shaded.io.netty.handler.codec.http.HttpClientCodec;
import com.hivemq.client.internal.shaded.io.netty.handler.codec.http.HttpObjectAggregator;
import com.hivemq.client.internal.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import com.hivemq.client.internal.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import com.hivemq.client.internal.shaded.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import com.hivemq.client.internal.shaded.javax.inject.Inject;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

@ConnectionScope
public class MqttWebSocketInitializer {
    @NotNull
    private static final String HTTP_CODEC_NAME = "http.codec";
    @NotNull
    private static final String HTTP_AGGREGATOR_NAME = "http.aggregator";
    @NotNull
    private final MqttWebSocketCodec mqttWebSocketCodec;

    @Inject
    MqttWebSocketInitializer(@NotNull MqttWebSocketCodec mqttWebSocketCodec) {
        this.mqttWebSocketCodec = mqttWebSocketCodec;
    }

    public void initChannel(@NotNull Channel channel, @NotNull MqttClientConfig clientConfig, @NotNull MqttWebSocketConfigImpl webSocketConfig, @NotNull Consumer<Channel> onSuccess, @NotNull BiConsumer<Channel, Throwable> onError) {
        URI uri;
        try {
            MqttClientTransportConfigImpl transportConfig = clientConfig.getCurrentTransportConfig();
            InetSocketAddress serverAddress = transportConfig.getServerAddress();
            uri = new URI(transportConfig.getRawSslConfig() == null ? "ws" : "wss", null, serverAddress.getHostString(), serverAddress.getPort(), "/" + webSocketConfig.getServerPath(), webSocketConfig.getQueryString(), null);
        }
        catch (URISyntaxException e) {
            onError.accept(channel, e);
            return;
        }
        WebSocketClientHandshaker handshaker = WebSocketClientHandshakerFactory.newHandshaker(uri, WebSocketVersion.V13, webSocketConfig.getSubprotocol(), true, null, 0x10000004, true, false);
        channel.pipeline().addLast(HTTP_CODEC_NAME, (ChannelHandler)new HttpClientCodec()).addLast(HTTP_AGGREGATOR_NAME, (ChannelHandler)new HttpObjectAggregator(65535)).addLast("http.headers", (ChannelHandler)new MqttWebSocketHttpHeaders(webSocketConfig.getHttpHeaders())).addLast("ws.handshake", (ChannelHandler)new MqttWebsocketHandshakeHandler(handshaker, webSocketConfig.getHandshakeTimeoutMs(), onSuccess, onError)).addLast("ws.mqtt", (ChannelHandler)this.mqttWebSocketCodec);
    }
}

