/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.lifecycle;

import com.hivemq.client.internal.mqtt.MqttClientConfig;
import com.hivemq.client.internal.mqtt.lifecycle.MqttClientReconnector;
import com.hivemq.client.internal.mqtt.lifecycle.mqtt3.Mqtt3ClientDisconnectedContextView;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.mqtt.MqttVersion;
import com.hivemq.client.mqtt.lifecycle.MqttClientDisconnectedContext;
import com.hivemq.client.mqtt.lifecycle.MqttDisconnectSource;
import com.hivemq.client.mqtt.mqtt5.lifecycle.Mqtt5ClientDisconnectedContext;

public class MqttClientDisconnectedContextImpl
implements Mqtt5ClientDisconnectedContext {
    @NotNull
    private final MqttClientConfig clientConfig;
    @NotNull
    private final MqttDisconnectSource source;
    @NotNull
    private final Throwable cause;
    @NotNull
    private final MqttClientReconnector reconnector;

    @NotNull
    public static MqttClientDisconnectedContext of(@NotNull MqttClientConfig clientConfig, @NotNull MqttDisconnectSource source, @NotNull Throwable cause, @NotNull MqttClientReconnector reconnector) {
        if (clientConfig.getMqttVersion() == MqttVersion.MQTT_3_1_1) {
            return Mqtt3ClientDisconnectedContextView.of(clientConfig, source, cause, reconnector);
        }
        return new MqttClientDisconnectedContextImpl(clientConfig, source, cause, reconnector);
    }

    private MqttClientDisconnectedContextImpl(@NotNull MqttClientConfig clientConfig, @NotNull MqttDisconnectSource source, @NotNull Throwable cause, @NotNull MqttClientReconnector reconnector) {
        this.clientConfig = clientConfig;
        this.source = source;
        this.cause = cause;
        this.reconnector = reconnector;
    }

    @Override
    @NotNull
    public MqttClientConfig getClientConfig() {
        return this.clientConfig;
    }

    @Override
    @NotNull
    public MqttDisconnectSource getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public Throwable getCause() {
        return this.cause;
    }

    @Override
    @NotNull
    public MqttClientReconnector getReconnector() {
        return this.reconnector;
    }
}

