/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.auth;

import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.message.auth.MqttSimpleAuth;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.datatypes.MqttUtf8String;
import com.hivemq.client.mqtt.mqtt5.message.auth.Mqtt5SimpleAuthBuilder;
import java.nio.ByteBuffer;
import java.util.function.Function;

public abstract class MqttSimpleAuthBuilder<B extends MqttSimpleAuthBuilder<B>> {
    @Nullable
    private MqttUtf8StringImpl username;
    @Nullable
    private ByteBuffer password;

    @NotNull
    abstract B self();

    @NotNull
    public B username(@Nullable String username) {
        this.username = MqttUtf8StringImpl.of(username, "Username");
        return this.self();
    }

    @NotNull
    public B username(@Nullable MqttUtf8String username) {
        this.username = MqttChecks.string(username, "Username");
        return this.self();
    }

    @NotNull
    public B password(byte @Nullable [] password) {
        this.password = MqttChecks.binaryData(password, "Password");
        return this.self();
    }

    @NotNull
    public B password(@Nullable ByteBuffer password) {
        this.password = MqttChecks.binaryData(password, "Password");
        return this.self();
    }

    @NotNull
    public MqttSimpleAuth build() {
        Checks.state(this.username != null || this.password != null, "Either user name or password must be given.");
        return new MqttSimpleAuth(this.username, this.password);
    }

    public static class Nested<P>
    extends MqttSimpleAuthBuilder<Nested<P>>
    implements Mqtt5SimpleAuthBuilder.Nested.Complete<P> {
        @NotNull
        private final Function<? super MqttSimpleAuth, P> parentConsumer;

        public Nested(@NotNull Function<? super MqttSimpleAuth, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Nested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applySimpleAuth() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Default
    extends MqttSimpleAuthBuilder<Default>
    implements Mqtt5SimpleAuthBuilder.Complete {
        @Override
        @NotNull
        Default self() {
            return this;
        }
    }
}

