/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.publish.mqtt3;

import com.hivemq.client.internal.mqtt.datatypes.MqttTopicImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicImplBuilder;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.mqtt.message.publish.MqttWillPublish;
import com.hivemq.client.internal.mqtt.message.publish.mqtt3.Mqtt3PublishView;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.ByteBufferUtil;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.datatypes.MqttTopic;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3PublishBuilder;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3WillPublishBuilder;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class Mqtt3PublishViewBuilder<B extends Mqtt3PublishViewBuilder<B>> {
    @Nullable
    MqttTopicImpl topic;
    @Nullable
    ByteBuffer payload;
    @NotNull
    MqttQos qos = Mqtt3PublishView.DEFAULT_QOS;
    boolean retain;

    Mqtt3PublishViewBuilder() {
    }

    Mqtt3PublishViewBuilder(@NotNull Mqtt3PublishView publish) {
        MqttPublish delegate = publish.getDelegate();
        this.topic = delegate.getTopic();
        this.payload = delegate.getRawPayload();
        this.qos = delegate.getQos();
        this.retain = delegate.isRetain();
    }

    @NotNull
    protected abstract B self();

    @NotNull
    public B topic(@Nullable String topic) {
        this.topic = MqttTopicImpl.of(topic);
        return this.self();
    }

    @NotNull
    public B topic(@Nullable MqttTopic topic) {
        this.topic = MqttChecks.topic(topic);
        return this.self();
    }

    public @NotNull MqttTopicImplBuilder.Nested<B> topic() {
        return new MqttTopicImplBuilder.Nested<Mqtt3PublishViewBuilder>(this::topic);
    }

    @NotNull
    public B qos(@Nullable MqttQos qos) {
        this.qos = Checks.notNull(qos, "QoS");
        return this.self();
    }

    @NotNull
    public B retain(boolean retain) {
        this.retain = retain;
        return this.self();
    }

    public static class WillNested<P>
    extends WillBase<WillNested<P>>
    implements Mqtt3WillPublishBuilder.Nested.Complete<P> {
        @NotNull
        private final Function<? super Mqtt3PublishView, P> parentConsumer;

        public WillNested(@NotNull Function<? super Mqtt3PublishView, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        protected WillNested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applyWillPublish() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class WillDefault
    extends WillBase<WillDefault>
    implements Mqtt3WillPublishBuilder.Complete {
        public WillDefault() {
        }

        WillDefault(@NotNull Mqtt3PublishView publish) {
            super(publish);
        }

        @Override
        @NotNull
        protected WillDefault self() {
            return this;
        }
    }

    private static abstract class WillBase<B extends WillBase<B>>
    extends Mqtt3PublishViewBuilder<B> {
        WillBase() {
        }

        WillBase(@NotNull Mqtt3PublishView publish) {
            super(publish);
            if (!(publish.getDelegate() instanceof MqttWillPublish)) {
                this.payload(this.payload);
            }
        }

        @NotNull
        public B payload(byte @Nullable [] payload) {
            this.payload = MqttChecks.binaryDataOrNull(payload, "Payload");
            return (B)((WillBase)this.self());
        }

        @NotNull
        public B payload(@Nullable ByteBuffer payload) {
            this.payload = MqttChecks.binaryDataOrNull(payload, "Payload");
            return (B)((WillBase)this.self());
        }

        @NotNull
        public Mqtt3PublishView build() {
            Checks.notNull(this.topic, "Topic");
            return Mqtt3PublishView.willOf(this.topic, this.payload, this.qos, this.retain);
        }
    }

    public static class SendVoid
    extends Base<SendVoid>
    implements Mqtt3PublishBuilder.SendVoid.Complete {
        @NotNull
        private final Consumer<? super Mqtt3PublishView> parentConsumer;

        public SendVoid(@NotNull Consumer<? super Mqtt3PublishView> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        protected SendVoid self() {
            return this;
        }

        @Override
        public void send() {
            this.parentConsumer.accept(this.build());
        }
    }

    public static class Send<P>
    extends Base<Send<P>>
    implements Mqtt3PublishBuilder.Send.Complete<P> {
        @NotNull
        private final Function<? super Mqtt3PublishView, P> parentConsumer;

        public Send(@NotNull Function<? super Mqtt3PublishView, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        protected Send<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P send() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Nested<P>
    extends Base<Nested<P>>
    implements Mqtt3PublishBuilder.Nested.Complete<P> {
        @NotNull
        private final Function<? super Mqtt3PublishView, P> parentConsumer;

        public Nested(@NotNull Function<? super Mqtt3PublishView, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        protected Nested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applyPublish() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Default
    extends Base<Default>
    implements Mqtt3PublishBuilder.Complete {
        public Default() {
        }

        Default(@NotNull Mqtt3PublishView publish) {
            super(publish);
        }

        @Override
        @NotNull
        protected Default self() {
            return this;
        }
    }

    private static abstract class Base<B extends Base<B>>
    extends Mqtt3PublishViewBuilder<B> {
        Base() {
        }

        Base(@NotNull Mqtt3PublishView publish) {
            super(publish);
        }

        @NotNull
        public B payload(byte @Nullable [] payload) {
            this.payload = ByteBufferUtil.wrap(payload);
            return (B)((Base)this.self());
        }

        @NotNull
        public B payload(@Nullable ByteBuffer payload) {
            this.payload = ByteBufferUtil.slice(payload);
            return (B)((Base)this.self());
        }

        @NotNull
        public Mqtt3PublishView build() {
            Checks.notNull(this.topic, "Topic");
            return Mqtt3PublishView.of(this.topic, this.payload, this.qos, this.retain);
        }
    }
}

