/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.subscribe.mqtt3;

import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImplBuilder;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscription;
import com.hivemq.client.internal.mqtt.message.subscribe.mqtt3.Mqtt3SubscriptionView;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import com.hivemq.client.mqtt.datatypes.MqttTopicFilter;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.Mqtt3Subscription;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.Mqtt3SubscriptionBuilder;
import java.util.function.Function;

public abstract class Mqtt3SubscriptionViewBuilder<B extends Mqtt3SubscriptionViewBuilder<B>> {
    @Nullable
    private MqttTopicFilterImpl topicFilter;
    @NotNull
    private MqttQos qos = Mqtt3SubscriptionView.DEFAULT_QOS;

    Mqtt3SubscriptionViewBuilder() {
    }

    Mqtt3SubscriptionViewBuilder(@NotNull Mqtt3SubscriptionView subscription) {
        MqttSubscription delegate = subscription.getDelegate();
        this.topicFilter = delegate.getTopicFilter();
        this.qos = delegate.getQos();
    }

    @NotNull
    abstract B self();

    @NotNull
    public B topicFilter(@Nullable String topicFilter) {
        this.topicFilter = MqttTopicFilterImpl.of(topicFilter);
        return this.self();
    }

    @NotNull
    public B topicFilter(@Nullable MqttTopicFilter topicFilter) {
        this.topicFilter = MqttChecks.topicFilter(topicFilter);
        return this.self();
    }

    public @NotNull MqttTopicFilterImplBuilder.Nested<B> topicFilter() {
        return new MqttTopicFilterImplBuilder.Nested<Mqtt3SubscriptionViewBuilder>(this::topicFilter);
    }

    @NotNull
    public B qos(@Nullable MqttQos qos) {
        this.qos = Checks.notNull(qos, "QoS");
        return this.self();
    }

    @NotNull
    public Mqtt3SubscriptionView build() {
        Checks.notNull(this.topicFilter, "Topic filter");
        return Mqtt3SubscriptionView.of(this.topicFilter, this.qos);
    }

    public static class Nested<P>
    extends Mqtt3SubscriptionViewBuilder<Nested<P>>
    implements Mqtt3SubscriptionBuilder.Nested.Complete<P> {
        @NotNull
        private final Function<? super Mqtt3Subscription, P> parentConsumer;

        public Nested(@NotNull Function<? super Mqtt3Subscription, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Nested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applySubscription() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Default
    extends Mqtt3SubscriptionViewBuilder<Default>
    implements Mqtt3SubscriptionBuilder.Complete {
        public Default() {
        }

        Default(@NotNull Mqtt3SubscriptionView subscription) {
            super(subscription);
        }

        @Override
        @NotNull
        Default self() {
            return this;
        }
    }
}

