/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.subscribe.suback.mqtt3;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.message.subscribe.suback.MqttSubAck;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.suback.Mqtt3SubAck;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.suback.Mqtt3SubAckReturnCode;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.suback.Mqtt5SubAck;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.suback.Mqtt5SubAckReasonCode;
import io.reactivex.functions.Function;

@Immutable
public class Mqtt3SubAckView
implements Mqtt3SubAck {
    @NotNull
    public static final Function<Mqtt5SubAck, Mqtt3SubAck> MAPPER = Mqtt3SubAckView::of;
    @NotNull
    private final MqttSubAck delegate;

    @NotNull
    public static MqttSubAck delegate(int packetIdentifier, @NotNull ImmutableList<Mqtt3SubAckReturnCode> returnCodes) {
        return new MqttSubAck(packetIdentifier, Mqtt3SubAckView.delegateReturnCodes(returnCodes), null, MqttUserPropertiesImpl.NO_USER_PROPERTIES);
    }

    @NotNull
    private static ImmutableList<Mqtt5SubAckReasonCode> delegateReturnCodes(@NotNull ImmutableList<Mqtt3SubAckReturnCode> returnCodes) {
        ImmutableList.Builder<Mqtt5SubAckReasonCode> builder = ImmutableList.builder(returnCodes.size());
        for (int i = 0; i < returnCodes.size(); ++i) {
            builder.add(Mqtt3SubAckView.delegateReturnCode(returnCodes.get(i)));
        }
        return builder.build();
    }

    @NotNull
    private static Mqtt5SubAckReasonCode delegateReturnCode(@NotNull Mqtt3SubAckReturnCode returnCode) {
        switch (returnCode) {
            case SUCCESS_MAXIMUM_QOS_0: {
                return Mqtt5SubAckReasonCode.GRANTED_QOS_0;
            }
            case SUCCESS_MAXIMUM_QOS_1: {
                return Mqtt5SubAckReasonCode.GRANTED_QOS_1;
            }
            case SUCCESS_MAXIMUM_QOS_2: {
                return Mqtt5SubAckReasonCode.GRANTED_QOS_2;
            }
            case FAILURE: {
                return Mqtt5SubAckReasonCode.UNSPECIFIED_ERROR;
            }
        }
        throw new IllegalStateException();
    }

    @NotNull
    private static ImmutableList<Mqtt3SubAckReturnCode> viewReasonCodes(@NotNull ImmutableList<Mqtt5SubAckReasonCode> reasonCodes) {
        ImmutableList.Builder<Mqtt3SubAckReturnCode> builder = ImmutableList.builder(reasonCodes.size());
        for (int i = 0; i < reasonCodes.size(); ++i) {
            builder.add(Mqtt3SubAckView.viewReasonCode(reasonCodes.get(i)));
        }
        return builder.build();
    }

    @NotNull
    private static Mqtt3SubAckReturnCode viewReasonCode(@NotNull Mqtt5SubAckReasonCode reasonCode) {
        switch (reasonCode) {
            case GRANTED_QOS_0: {
                return Mqtt3SubAckReturnCode.SUCCESS_MAXIMUM_QOS_0;
            }
            case GRANTED_QOS_1: {
                return Mqtt3SubAckReturnCode.SUCCESS_MAXIMUM_QOS_1;
            }
            case GRANTED_QOS_2: {
                return Mqtt3SubAckReturnCode.SUCCESS_MAXIMUM_QOS_2;
            }
            case UNSPECIFIED_ERROR: {
                return Mqtt3SubAckReturnCode.FAILURE;
            }
        }
        throw new IllegalStateException();
    }

    @NotNull
    public static Mqtt3SubAckView of(@NotNull Mqtt5SubAck subAck) {
        return new Mqtt3SubAckView((MqttSubAck)subAck);
    }

    @NotNull
    public static Mqtt3SubAckView of(@NotNull MqttSubAck subAck) {
        return new Mqtt3SubAckView(subAck);
    }

    private Mqtt3SubAckView(@NotNull MqttSubAck delegate) {
        this.delegate = delegate;
    }

    @NotNull
    public @NotNull ImmutableList<@NotNull Mqtt3SubAckReturnCode> getReturnCodes() {
        return Mqtt3SubAckView.viewReasonCodes((ImmutableList<Mqtt5SubAckReasonCode>)this.delegate.getReasonCodes());
    }

    @NotNull
    public MqttSubAck getDelegate() {
        return this.delegate;
    }

    @NotNull
    private String toAttributeString() {
        return "returnCodes=" + this.getReturnCodes();
    }

    @NotNull
    public String toString() {
        return "MqttSubAck{" + this.toAttributeString() + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Mqtt3SubAckView)) {
            return false;
        }
        Mqtt3SubAckView that = (Mqtt3SubAckView)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

