/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.mqtt3;

import com.hivemq.client.internal.mqtt.MqttAsyncClient;
import com.hivemq.client.internal.mqtt.exceptions.mqtt3.Mqtt3ExceptionFactory;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.internal.mqtt.message.connect.connack.mqtt3.Mqtt3ConnAckView;
import com.hivemq.client.internal.mqtt.message.connect.mqtt3.Mqtt3ConnectView;
import com.hivemq.client.internal.mqtt.message.connect.mqtt3.Mqtt3ConnectViewBuilder;
import com.hivemq.client.internal.mqtt.message.disconnect.mqtt3.Mqtt3DisconnectView;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.mqtt.message.publish.mqtt3.Mqtt3PublishView;
import com.hivemq.client.internal.mqtt.message.publish.mqtt3.Mqtt3PublishViewBuilder;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscribe;
import com.hivemq.client.internal.mqtt.message.subscribe.mqtt3.Mqtt3SubscribeView;
import com.hivemq.client.internal.mqtt.message.subscribe.mqtt3.Mqtt3SubscribeViewBuilder;
import com.hivemq.client.internal.mqtt.message.subscribe.suback.mqtt3.Mqtt3SubAckView;
import com.hivemq.client.internal.mqtt.message.unsubscribe.MqttUnsubscribe;
import com.hivemq.client.internal.mqtt.message.unsubscribe.mqtt3.Mqtt3UnsubscribeViewBuilder;
import com.hivemq.client.internal.mqtt.mqtt3.Mqtt3BlockingClientView;
import com.hivemq.client.internal.mqtt.mqtt3.Mqtt3ClientConfigView;
import com.hivemq.client.internal.mqtt.mqtt3.Mqtt3RxClientView;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.MqttGlobalPublishFilter;
import com.hivemq.client.mqtt.mqtt3.Mqtt3AsyncClient;
import com.hivemq.client.mqtt.mqtt3.Mqtt3BlockingClient;
import com.hivemq.client.mqtt.mqtt3.Mqtt3ClientConfig;
import com.hivemq.client.mqtt.mqtt3.Mqtt3RxClient;
import com.hivemq.client.mqtt.mqtt3.message.connect.Mqtt3Connect;
import com.hivemq.client.mqtt.mqtt3.message.connect.connack.Mqtt3ConnAck;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3Publish;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.Mqtt3Subscribe;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.suback.Mqtt3SubAck;
import com.hivemq.client.mqtt.mqtt3.message.unsubscribe.Mqtt3Unsubscribe;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5Publish;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.Mqtt5Subscribe;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.suback.Mqtt5SubAck;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class Mqtt3AsyncClientView
implements Mqtt3AsyncClient {
    @NotNull
    private final MqttAsyncClient delegate;
    @NotNull
    private final Mqtt3ClientConfigView clientConfig;

    @NotNull
    private static @NotNull CompletableFuture<@NotNull Mqtt3SubAck> handleSubAck(@NotNull @NotNull CompletableFuture<@NotNull Mqtt5SubAck> future) {
        CompletableFuture<Mqtt3SubAck> mappedFuture = new CompletableFuture<Mqtt3SubAck>();
        future.whenComplete((subAck, throwable) -> {
            if (throwable != null) {
                mappedFuture.completeExceptionally(Mqtt3ExceptionFactory.map(throwable));
            } else {
                mappedFuture.complete(Mqtt3SubAckView.of(subAck));
            }
        });
        return mappedFuture;
    }

    @NotNull
    private static Consumer<Mqtt5Publish> callbackView(@NotNull Consumer<Mqtt3Publish> callback) {
        return publish -> callback.accept(Mqtt3PublishView.of(publish));
    }

    Mqtt3AsyncClientView(@NotNull MqttAsyncClient delegate) {
        this.delegate = delegate;
        this.clientConfig = new Mqtt3ClientConfigView(delegate.getConfig());
    }

    @Override
    @NotNull
    public @NotNull CompletableFuture<@NotNull Mqtt3ConnAck> connect() {
        return this.connect(Mqtt3ConnectView.DEFAULT);
    }

    @Override
    @NotNull
    public @NotNull CompletableFuture<@NotNull Mqtt3ConnAck> connect(@Nullable Mqtt3Connect connect) {
        MqttConnect mqttConnect = MqttChecks.connect(connect);
        CompletableFuture<Mqtt3ConnAck> future = new CompletableFuture<Mqtt3ConnAck>();
        this.delegate.connect(mqttConnect).whenComplete((connAck, throwable) -> {
            if (throwable != null) {
                future.completeExceptionally(Mqtt3ExceptionFactory.map(throwable));
            } else {
                future.complete(Mqtt3ConnAckView.of(connAck));
            }
        });
        return future;
    }

    public  @NotNull Mqtt3ConnectViewBuilder.Send<CompletableFuture<Mqtt3ConnAck>> connectWith() {
        return new Mqtt3ConnectViewBuilder.Send<CompletableFuture<Mqtt3ConnAck>>(this::connect);
    }

    @Override
    @NotNull
    public @NotNull CompletableFuture<@NotNull Mqtt3SubAck> subscribe(@Nullable Mqtt3Subscribe subscribe) {
        MqttSubscribe mqttSubscribe = MqttChecks.subscribe(subscribe);
        return Mqtt3AsyncClientView.handleSubAck(this.delegate.subscribe(mqttSubscribe));
    }

    @Override
    @NotNull
    public @NotNull CompletableFuture<@NotNull Mqtt3SubAck> subscribe(@Nullable Mqtt3Subscribe subscribe, @Nullable Consumer<@NotNull Mqtt3Publish> callback) {
        return this.subscribe(subscribe, callback, false);
    }

    @Override
    @NotNull
    public @NotNull CompletableFuture<@NotNull Mqtt3SubAck> subscribe(@Nullable Mqtt3Subscribe subscribe, @Nullable Consumer<@NotNull Mqtt3Publish> callback, @Nullable Executor executor) {
        return this.subscribe(subscribe, callback, executor, false);
    }

    @Override
    @NotNull
    public @NotNull CompletableFuture<@NotNull Mqtt3SubAck> subscribe(@Nullable Mqtt3Subscribe subscribe, @Nullable Consumer<@NotNull Mqtt3Publish> callback, boolean manualAcknowledgement) {
        MqttSubscribe mqttSubscribe = MqttChecks.subscribe(subscribe);
        Checks.notNull(callback, "Callback");
        return Mqtt3AsyncClientView.handleSubAck(this.delegate.subscribe((Mqtt5Subscribe)mqttSubscribe, Mqtt3AsyncClientView.callbackView(callback), manualAcknowledgement));
    }

    @Override
    @NotNull
    public @NotNull CompletableFuture<@NotNull Mqtt3SubAck> subscribe(@Nullable Mqtt3Subscribe subscribe, @Nullable Consumer<@NotNull Mqtt3Publish> callback, @Nullable Executor executor, boolean manualAcknowledgement) {
        MqttSubscribe mqttSubscribe = MqttChecks.subscribe(subscribe);
        Checks.notNull(callback, "Callback");
        Checks.notNull(executor, "Executor");
        return Mqtt3AsyncClientView.handleSubAck(this.delegate.subscribe(mqttSubscribe, Mqtt3AsyncClientView.callbackView(callback), executor, manualAcknowledgement));
    }

    @Override
    @NotNull
    public Mqtt3SubscribeViewAndCallbackBuilder subscribeWith() {
        return new Mqtt3SubscribeViewAndCallbackBuilder();
    }

    @Override
    public void publishes(@Nullable MqttGlobalPublishFilter filter, @Nullable Consumer<@NotNull Mqtt3Publish> callback) {
        this.publishes(filter, callback, false);
    }

    @Override
    public void publishes(@Nullable MqttGlobalPublishFilter filter, @Nullable Consumer<@NotNull Mqtt3Publish> callback, @Nullable Executor executor) {
        this.publishes(filter, callback, executor, false);
    }

    @Override
    public void publishes(@Nullable MqttGlobalPublishFilter filter, @Nullable Consumer<@NotNull Mqtt3Publish> callback, boolean manualAcknowledgement) {
        Checks.notNull(filter, "Global publish filter");
        Checks.notNull(callback, "Callback");
        this.delegate.publishes(filter, Mqtt3AsyncClientView.callbackView(callback), manualAcknowledgement);
    }

    @Override
    public void publishes(@Nullable MqttGlobalPublishFilter filter, @Nullable Consumer<@NotNull Mqtt3Publish> callback, @Nullable Executor executor, boolean manualAcknowledgement) {
        Checks.notNull(filter, "Global publish filter");
        Checks.notNull(callback, "Callback");
        Checks.notNull(executor, "Executor");
        this.delegate.publishes(filter, Mqtt3AsyncClientView.callbackView(callback), executor, manualAcknowledgement);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> unsubscribe(@Nullable Mqtt3Unsubscribe unsubscribe) {
        MqttUnsubscribe mqttUnsubscribe = MqttChecks.unsubscribe(unsubscribe);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.delegate.unsubscribe(mqttUnsubscribe).whenComplete((unsubAck, throwable) -> {
            if (throwable != null) {
                future.completeExceptionally(Mqtt3ExceptionFactory.map(throwable));
            } else {
                future.complete(null);
            }
        });
        return future;
    }

    public  @NotNull Mqtt3UnsubscribeViewBuilder.Send<CompletableFuture<Void>> unsubscribeWith() {
        return new Mqtt3UnsubscribeViewBuilder.Send<CompletableFuture<Void>>(this::unsubscribe);
    }

    @Override
    @NotNull
    public @NotNull CompletableFuture<@NotNull Mqtt3Publish> publish(@Nullable Mqtt3Publish publish) {
        MqttPublish mqttPublish = MqttChecks.publish(publish);
        CompletableFuture<Mqtt3Publish> future = new CompletableFuture<Mqtt3Publish>();
        this.delegate.publish(mqttPublish).whenComplete((publishResult, throwable) -> {
            if (throwable != null) {
                future.completeExceptionally(Mqtt3ExceptionFactory.map(throwable));
            } else {
                future.complete(Mqtt3PublishView.of(publishResult.getPublish()));
            }
        });
        return future;
    }

    public  @NotNull Mqtt3PublishViewBuilder.Send<CompletableFuture<Mqtt3Publish>> publishWith() {
        return new Mqtt3PublishViewBuilder.Send<CompletableFuture<Mqtt3Publish>>(this::publish);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> disconnect() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.delegate.disconnect(Mqtt3DisconnectView.DELEGATE).whenComplete((ignored, throwable) -> {
            if (throwable != null) {
                future.completeExceptionally(Mqtt3ExceptionFactory.map(throwable));
            } else {
                future.complete(null);
            }
        });
        return future;
    }

    @Override
    @NotNull
    public Mqtt3ClientConfig getConfig() {
        return this.clientConfig;
    }

    @Override
    @NotNull
    public Mqtt3RxClient toRx() {
        return new Mqtt3RxClientView(this.delegate.toRx());
    }

    @Override
    @NotNull
    public Mqtt3BlockingClient toBlocking() {
        return new Mqtt3BlockingClientView(this.delegate.toBlocking());
    }

    private class Mqtt3SubscribeViewAndCallbackBuilder
    extends Mqtt3SubscribeViewBuilder<Mqtt3SubscribeViewAndCallbackBuilder>
    implements Mqtt3AsyncClient.Mqtt3SubscribeAndCallbackBuilder.Start.Complete,
    Mqtt3AsyncClient.Mqtt3SubscribeAndCallbackBuilder.Call.Ex {
        @Nullable
        private Consumer<Mqtt3Publish> callback;
        @Nullable
        private Executor executor;
        private boolean manualAcknowledgement;

        private Mqtt3SubscribeViewAndCallbackBuilder() {
        }

        @Override
        @NotNull
        protected Mqtt3SubscribeViewAndCallbackBuilder self() {
            return this;
        }

        @Override
        @NotNull
        public Mqtt3SubscribeViewAndCallbackBuilder callback(@Nullable Consumer<Mqtt3Publish> callback) {
            this.callback = Checks.notNull(callback, "Callback");
            return this;
        }

        @Override
        @NotNull
        public Mqtt3SubscribeViewAndCallbackBuilder executor(@Nullable Executor executor) {
            this.executor = Checks.notNull(executor, "Executor");
            return this;
        }

        @Override
        @NotNull
        public Mqtt3SubscribeViewAndCallbackBuilder manualAcknowledgement(boolean manualAcknowledgement) {
            this.manualAcknowledgement = manualAcknowledgement;
            return this;
        }

        @Override
        @NotNull
        public CompletableFuture<Mqtt3SubAck> send() {
            Mqtt3SubscribeView subscribe = this.build();
            if (this.callback == null) {
                Checks.state(this.executor == null, "Executor must not be given if callback is null.");
                Checks.state(!this.manualAcknowledgement, "Manual acknowledgement must not be true if callback is null.");
                return Mqtt3AsyncClientView.this.subscribe(subscribe);
            }
            if (this.executor == null) {
                return Mqtt3AsyncClientView.this.subscribe((Mqtt3Subscribe)subscribe, this.callback, this.manualAcknowledgement);
            }
            return Mqtt3AsyncClientView.this.subscribe(subscribe, this.callback, this.executor, this.manualAcknowledgement);
        }
    }
}

