/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.mqtt3;

import com.hivemq.client.internal.mqtt.MqttRxClient;
import com.hivemq.client.internal.mqtt.exceptions.mqtt3.Mqtt3ExceptionFactory;
import com.hivemq.client.internal.mqtt.message.connect.MqttConnect;
import com.hivemq.client.internal.mqtt.message.connect.connack.mqtt3.Mqtt3ConnAckView;
import com.hivemq.client.internal.mqtt.message.connect.mqtt3.Mqtt3ConnectView;
import com.hivemq.client.internal.mqtt.message.connect.mqtt3.Mqtt3ConnectViewBuilder;
import com.hivemq.client.internal.mqtt.message.disconnect.mqtt3.Mqtt3DisconnectView;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.mqtt.message.publish.mqtt3.Mqtt3PublishResultView;
import com.hivemq.client.internal.mqtt.message.publish.mqtt3.Mqtt3PublishView;
import com.hivemq.client.internal.mqtt.message.subscribe.MqttSubscribe;
import com.hivemq.client.internal.mqtt.message.subscribe.mqtt3.Mqtt3SubscribeViewBuilder;
import com.hivemq.client.internal.mqtt.message.subscribe.suback.mqtt3.Mqtt3SubAckView;
import com.hivemq.client.internal.mqtt.message.unsubscribe.MqttUnsubscribe;
import com.hivemq.client.internal.mqtt.message.unsubscribe.mqtt3.Mqtt3UnsubscribeViewBuilder;
import com.hivemq.client.internal.mqtt.mqtt3.Mqtt3AsyncClientView;
import com.hivemq.client.internal.mqtt.mqtt3.Mqtt3BlockingClientView;
import com.hivemq.client.internal.mqtt.mqtt3.Mqtt3ClientConfigView;
import com.hivemq.client.internal.mqtt.util.MqttChecks;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.MqttGlobalPublishFilter;
import com.hivemq.client.mqtt.mqtt3.Mqtt3RxClient;
import com.hivemq.client.mqtt.mqtt3.message.connect.Mqtt3Connect;
import com.hivemq.client.mqtt.mqtt3.message.connect.connack.Mqtt3ConnAck;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3Publish;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3PublishResult;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.Mqtt3Subscribe;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.suback.Mqtt3SubAck;
import com.hivemq.client.mqtt.mqtt3.message.unsubscribe.Mqtt3Unsubscribe;
import com.hivemq.client.mqtt.mqtt5.message.connect.Mqtt5Connect;
import com.hivemq.client.mqtt.mqtt5.message.connect.connack.Mqtt5ConnAck;
import com.hivemq.client.mqtt.mqtt5.message.disconnect.Mqtt5Disconnect;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5Publish;
import com.hivemq.client.mqtt.mqtt5.message.publish.Mqtt5PublishResult;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.Mqtt5Subscribe;
import com.hivemq.client.mqtt.mqtt5.message.subscribe.suback.Mqtt5SubAck;
import com.hivemq.client.mqtt.mqtt5.message.unsubscribe.Mqtt5Unsubscribe;
import com.hivemq.client.rx.FlowableWithSingle;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.functions.Function;

public class Mqtt3RxClientView
implements Mqtt3RxClient {
    @NotNull
    private static final Function<Mqtt3Publish, MqttPublish> PUBLISH_MAPPER = MqttChecks::publish;
    @NotNull
    private static final Function<Throwable, Completable> EXCEPTION_MAPPER_COMPLETABLE = e -> Completable.error((Throwable)Mqtt3ExceptionFactory.map(e));
    @NotNull
    private static final Function<Throwable, Single<Mqtt5ConnAck>> EXCEPTION_MAPPER_SINGLE_CONNACK = e -> Single.error((Throwable)Mqtt3ExceptionFactory.map(e));
    @NotNull
    private static final Function<Throwable, Single<Mqtt5SubAck>> EXCEPTION_MAPPER_SINGLE_SUBACK = e -> Single.error((Throwable)Mqtt3ExceptionFactory.map(e));
    @NotNull
    private static final Function<Throwable, Flowable<Mqtt5Publish>> EXCEPTION_MAPPER_FLOWABLE_PUBLISH = e -> Flowable.error((Throwable)Mqtt3ExceptionFactory.map(e));
    @NotNull
    private static final Function<Throwable, Flowable<Mqtt5PublishResult>> EXCEPTION_MAPPER_FLOWABLE_PUBLISH_RESULT = e -> Flowable.error((Throwable)Mqtt3ExceptionFactory.map(e));
    @NotNull
    private final MqttRxClient delegate;
    @NotNull
    private final Mqtt3ClientConfigView clientConfig;

    Mqtt3RxClientView(@NotNull MqttRxClient delegate) {
        this.delegate = delegate;
        this.clientConfig = new Mqtt3ClientConfigView(delegate.getConfig());
    }

    @Override
    @NotNull
    public Single<Mqtt3ConnAck> connect() {
        return this.connect(Mqtt3ConnectView.DEFAULT);
    }

    @Override
    @NotNull
    public Single<Mqtt3ConnAck> connect(@Nullable Mqtt3Connect connect) {
        MqttConnect mqttConnect = MqttChecks.connect(connect);
        return this.delegate.connect((Mqtt5Connect)mqttConnect).onErrorResumeNext(EXCEPTION_MAPPER_SINGLE_CONNACK).map(Mqtt3ConnAckView.MAPPER);
    }

    public  @NotNull Mqtt3ConnectViewBuilder.Nested<Single<Mqtt3ConnAck>> connectWith() {
        return new Mqtt3ConnectViewBuilder.Nested<Single<Mqtt3ConnAck>>(this::connect);
    }

    @Override
    @NotNull
    public Single<Mqtt3SubAck> subscribe(@Nullable Mqtt3Subscribe subscribe) {
        MqttSubscribe mqttSubscribe = MqttChecks.subscribe(subscribe);
        return this.delegate.subscribe((Mqtt5Subscribe)mqttSubscribe).onErrorResumeNext(EXCEPTION_MAPPER_SINGLE_SUBACK).map(Mqtt3SubAckView.MAPPER);
    }

    public  @NotNull Mqtt3SubscribeViewBuilder.Nested<Single<Mqtt3SubAck>> subscribeWith() {
        return new Mqtt3SubscribeViewBuilder.Nested<Single<Mqtt3SubAck>>(this::subscribe);
    }

    @Override
    @NotNull
    public FlowableWithSingle<Mqtt3Publish, Mqtt3SubAck> subscribeStream(@NotNull Mqtt3Subscribe subscribe) {
        return this.subscribePublishes(subscribe);
    }

    public  @NotNull Mqtt3SubscribeViewBuilder.Nested<FlowableWithSingle<Mqtt3Publish, Mqtt3SubAck>> subscribeStreamWith() {
        return new Mqtt3SubscribeViewBuilder.Nested<FlowableWithSingle<Mqtt3Publish, Mqtt3SubAck>>(this::subscribeStream);
    }

    @Override
    @NotNull
    public FlowableWithSingle<Mqtt3Publish, Mqtt3SubAck> subscribePublishes(@Nullable Mqtt3Subscribe subscribe) {
        return this.subscribePublishes(subscribe, false);
    }

    @Override
    @NotNull
    public FlowableWithSingle<Mqtt3Publish, Mqtt3SubAck> subscribePublishes(@Nullable Mqtt3Subscribe subscribe, boolean manualAcknowledgement) {
        MqttSubscribe mqttSubscribe = MqttChecks.subscribe(subscribe);
        return this.delegate.subscribePublishes((Mqtt5Subscribe)mqttSubscribe, manualAcknowledgement).mapError(Mqtt3ExceptionFactory.MAPPER).mapBoth(Mqtt3PublishView.MAPPER, Mqtt3SubAckView.MAPPER);
    }

    @NotNull
    public Mqtt3SubscribeViewPublishesBuilder subscribePublishesWith() {
        return new Mqtt3SubscribeViewPublishesBuilder();
    }

    @Override
    @NotNull
    public Flowable<Mqtt3Publish> publishes(@Nullable MqttGlobalPublishFilter filter) {
        return this.publishes(filter, false);
    }

    @Override
    @NotNull
    public Flowable<Mqtt3Publish> publishes(@Nullable MqttGlobalPublishFilter filter, boolean manualAcknowledgement) {
        Checks.notNull(filter, "Global publish filter");
        return this.delegate.publishes(filter, manualAcknowledgement).onErrorResumeNext(EXCEPTION_MAPPER_FLOWABLE_PUBLISH).map(Mqtt3PublishView.MAPPER);
    }

    @Override
    @NotNull
    public Completable unsubscribe(@Nullable Mqtt3Unsubscribe unsubscribe) {
        MqttUnsubscribe mqttUnsubscribe = MqttChecks.unsubscribe(unsubscribe);
        return this.delegate.unsubscribe((Mqtt5Unsubscribe)mqttUnsubscribe).ignoreElement().onErrorResumeNext(EXCEPTION_MAPPER_COMPLETABLE);
    }

    public  @NotNull Mqtt3UnsubscribeViewBuilder.Nested<Completable> unsubscribeWith() {
        return new Mqtt3UnsubscribeViewBuilder.Nested<Completable>(this::unsubscribe);
    }

    @Override
    @NotNull
    public Flowable<Mqtt3PublishResult> publish(@Nullable Flowable<Mqtt3Publish> publishFlowable) {
        Checks.notNull(publishFlowable, "Publish flowable");
        return this.delegate.publish(publishFlowable, PUBLISH_MAPPER).onErrorResumeNext(EXCEPTION_MAPPER_FLOWABLE_PUBLISH_RESULT).map(Mqtt3PublishResultView.MAPPER);
    }

    @Override
    @NotNull
    public Completable disconnect() {
        return this.delegate.disconnect((Mqtt5Disconnect)Mqtt3DisconnectView.DELEGATE).onErrorResumeNext(EXCEPTION_MAPPER_COMPLETABLE);
    }

    @Override
    @NotNull
    public Mqtt3ClientConfigView getConfig() {
        return this.clientConfig;
    }

    @Override
    @NotNull
    public Mqtt3AsyncClientView toAsync() {
        return new Mqtt3AsyncClientView(this.delegate.toAsync());
    }

    @Override
    @NotNull
    public Mqtt3BlockingClientView toBlocking() {
        return new Mqtt3BlockingClientView(this.delegate.toBlocking());
    }

    private class Mqtt3SubscribeViewPublishesBuilder
    extends Mqtt3SubscribeViewBuilder.Publishes<FlowableWithSingle<Mqtt3Publish, Mqtt3SubAck>> {
        private Mqtt3SubscribeViewPublishesBuilder() {
        }

        @Override
        @NotNull
        public FlowableWithSingle<Mqtt3Publish, Mqtt3SubAck> applySubscribe() {
            return Mqtt3RxClientView.this.subscribePublishes(this.build(), this.manualAcknowledgement);
        }
    }
}

