/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.rx.operators;

import com.hivemq.client.internal.rx.WithSingleConditionalSubscriber;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.rx.FlowableWithSingle;
import com.hivemq.client.rx.FlowableWithSingleSubscriber;
import com.hivemq.client.rx.reactivestreams.WithSingleSubscriber;
import io.reactivex.Flowable;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class FlowableWithSingleCombine<F, S>
extends Flowable<Object> {
    @NotNull
    private final FlowableWithSingle<F, S> source;

    FlowableWithSingleCombine(@NotNull FlowableWithSingle<F, S> source) {
        this.source = source;
    }

    protected void subscribeActual(@NotNull Subscriber<? super Object> subscriber) {
        this.source.subscribeBoth(new CombineSubscriber(subscriber));
    }

    static <F, S> void split(@NotNull Flowable<Object> source, @NotNull WithSingleSubscriber<? super F, ? super S> subscriber) {
        if (subscriber instanceof WithSingleConditionalSubscriber) {
            source.subscribe(new SplitSubscriber.Conditional((WithSingleConditionalSubscriber)subscriber));
        } else {
            source.subscribe(new SplitSubscriber.Default<F, S>(subscriber));
        }
    }

    private static class SingleElement {
        @NotNull
        final Object element;

        SingleElement(@NotNull Object element) {
            this.element = element;
        }
    }

    private static abstract class SplitSubscriber<F, S, T extends WithSingleSubscriber<? super F, ? super S>>
    implements ConditionalSubscriber<Object>,
    Subscription {
        @NotNull
        final T subscriber;
        @Nullable
        private Subscription subscription;

        SplitSubscriber(@NotNull T subscriber) {
            this.subscriber = subscriber;
        }

        public void onSubscribe(@NotNull Subscription subscription) {
            this.subscription = subscription;
            this.subscriber.onSubscribe((Subscription)this);
        }

        public void onNext(@NotNull Object o) {
            if (!this.tryOnNext(o)) {
                assert (this.subscription != null);
                this.subscription.request(1L);
            }
        }

        public boolean tryOnNext(@NotNull Object o) {
            if (o instanceof SingleElement) {
                this.subscriber.onSingle((Object)((SingleElement)o).element);
                return false;
            }
            return this.tryOnNextActual(o);
        }

        abstract boolean tryOnNextActual(@NotNull F var1);

        public void onError(@NotNull Throwable throwable) {
            this.subscriber.onError(throwable);
        }

        public void onComplete() {
            this.subscriber.onComplete();
        }

        public void request(long n) {
            assert (this.subscription != null);
            this.subscription.request(n);
        }

        public void cancel() {
            assert (this.subscription != null);
            this.subscription.cancel();
        }

        private static class Conditional<F, S>
        extends SplitSubscriber<F, S, WithSingleConditionalSubscriber<? super F, ? super S>> {
            Conditional(@NotNull WithSingleConditionalSubscriber<? super F, ? super S> subscriber) {
                super(subscriber);
            }

            @Override
            boolean tryOnNextActual(@NotNull F f) {
                return ((WithSingleConditionalSubscriber)this.subscriber).tryOnNext(f);
            }
        }

        private static class Default<F, S>
        extends SplitSubscriber<F, S, WithSingleSubscriber<? super F, ? super S>> {
            Default(@NotNull WithSingleSubscriber<? super F, ? super S> subscriber) {
                super(subscriber);
            }

            @Override
            boolean tryOnNextActual(@NotNull F f) {
                this.subscriber.onNext(f);
                return true;
            }
        }
    }

    private static class CombineSubscriber<F, S>
    implements FlowableWithSingleSubscriber<F, S>,
    Subscription {
        @NotNull
        private static final Object COMPLETE = new Object();
        @NotNull
        private final Subscriber<? super Object> subscriber;
        @Nullable
        private Subscription subscription;
        @NotNull
        private final AtomicLong requested = new AtomicLong();
        @Nullable
        private Object queued;
        @Nullable
        private Object done;

        CombineSubscriber(@NotNull Subscriber<? super Object> subscriber) {
            this.subscriber = subscriber;
        }

        public void onSubscribe(@NotNull Subscription subscription) {
            this.subscription = subscription;
            this.subscriber.onSubscribe((Subscription)this);
        }

        @Override
        public void onSingle(@NotNull S s) {
            this.next(new SingleElement(s));
        }

        public void onNext(@NotNull F f) {
            this.next(f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void next(@NotNull Object next) {
            if (this.requested.get() == 0L) {
                CombineSubscriber combineSubscriber = this;
                synchronized (combineSubscriber) {
                    if (this.requested.get() == 0L) {
                        this.queued = next;
                        return;
                    }
                }
            }
            BackpressureHelper.produced((AtomicLong)this.requested, (long)1L);
            this.subscriber.onNext(next);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete() {
            CombineSubscriber combineSubscriber = this;
            synchronized (combineSubscriber) {
                if (this.queued != null) {
                    this.done = COMPLETE;
                } else {
                    this.subscriber.onComplete();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(@NotNull Throwable error) {
            CombineSubscriber combineSubscriber = this;
            synchronized (combineSubscriber) {
                if (this.queued != null) {
                    this.done = error;
                } else {
                    this.subscriber.onError(error);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void request(long n) {
            assert (this.subscription != null);
            if (n > 0L) {
                if (BackpressureHelper.add((AtomicLong)this.requested, (long)n) == 0L) {
                    CombineSubscriber combineSubscriber = this;
                    synchronized (combineSubscriber) {
                        Object queued = this.queued;
                        if (queued != null) {
                            this.queued = null;
                            BackpressureHelper.produced((AtomicLong)this.requested, (long)1L);
                            this.subscriber.onNext(queued);
                            --n;
                            Object done = this.done;
                            if (done != null) {
                                this.done = null;
                                if (done instanceof Throwable) {
                                    this.subscriber.onError((Throwable)done);
                                } else {
                                    this.subscriber.onComplete();
                                }
                                return;
                            }
                        }
                        if (n > 0L) {
                            this.subscription.request(n);
                        }
                    }
                } else {
                    this.subscription.request(n);
                }
            }
        }

        public void cancel() {
            assert (this.subscription != null);
            this.subscription.cancel();
        }
    }
}

