/*
 * Decompiled with CFR 0.152.
 */
package com.holdenkarau.spark.testing;

import com.holdenkarau.spark.testing.DataFrameSuiteBase$;
import com.holdenkarau.spark.testing.DataFrameSuiteBaseLike;
import com.holdenkarau.spark.testing.SparkSessionProvider$;
import com.holdenkarau.spark.testing.Utils$;
import com.holdenkarau.spark.testing.WrappedConfVar;
import java.io.File;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class DataFrameSuiteBaseLike$class {
    public static SparkSession spark(DataFrameSuiteBaseLike $this) {
        return SparkSessionProvider$.MODULE$._sparkSession();
    }

    public static SQLContext sqlContext(DataFrameSuiteBaseLike $this) {
        return SparkSessionProvider$.MODULE$.sqlContext();
    }

    public static SQLContext impSqlContext(DataFrameSuiteBaseLike $this) {
        return $this.sqlContext();
    }

    public static boolean enableHiveSupport(DataFrameSuiteBaseLike $this) {
        return true;
    }

    public static boolean enableIcebergSupport(DataFrameSuiteBaseLike $this) {
        return false;
    }

    public static File tempDir(DataFrameSuiteBaseLike $this) {
        return Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1());
    }

    public static String localMetastorePath(DataFrameSuiteBaseLike $this) {
        return new File($this.tempDir(), "metastore").getCanonicalPath();
    }

    public static String localWarehousePath(DataFrameSuiteBaseLike $this) {
        return new File($this.tempDir(), "warehouse").getCanonicalPath();
    }

    /*
     * WARNING - void declaration
     */
    public static SparkSession.Builder builder(DataFrameSuiteBaseLike $this) {
        void var1_1;
        BoxedUnit boxedUnit;
        Object object;
        BoxedUnit boxedUnit2;
        SparkSession.Builder builder2 = SparkSession$.MODULE$.builder();
        builder2.config("spark.io.compression.codec", "snappy");
        if ($this.enableHiveSupport()) {
            HiveConf.ConfVars[] hiveConfVars = HiveConf.ConfVars.values();
            WrappedConfVar[] accessiableHiveConfVars = (WrappedConfVar[])Predef$.MODULE$.refArrayOps((Object[])hiveConfVars).map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final WrappedConfVar apply(HiveConf.ConfVars x$2) {
                    return new WrappedConfVar(x$2);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(WrappedConfVar.class)));
            Predef$.MODULE$.refArrayOps((Object[])accessiableHiveConfVars).foreach((Function1)new Serializable($this, builder2){
                public static final long serialVersionUID = 0L;
                private final SparkSession.Builder builder$1;

                public final Object apply(WrappedConfVar confvar) {
                    return confvar.varname().contains("datanucleus") || confvar.varname().contains("jdo") ? this.builder$1.config(confvar.varname(), confvar.getDefaultExpr()) : BoxedUnit.UNIT;
                }
                {
                    this.builder$1 = builder$1;
                }
            });
            builder2.config(HiveConf.ConfVars.METASTOREURIS.varname, "");
            builder2.config("javax.jdo.option.ConnectionURL", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jdbc:derby:;databaseName=", ";create=true"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.localMetastorePath()})));
            boxedUnit2 = builder2.config("datanucleus.rdbms.datastoreAdapterClassName", "org.datanucleus.store.rdbms.adapter.DerbyAdapter");
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        builder2.config("spark.sql.streaming.checkpointLocation", ((Object)Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1()).toPath()).toString());
        builder2.config("spark.sql.warehouse.dir", $this.localWarehousePath());
        try {
            object = $this.enableHiveSupport() ? builder2.enableHiveSupport() : BoxedUnit.UNIT;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object = BoxedUnit.UNIT;
        }
        if ($this.enableIcebergSupport()) {
            builder2.config("spark.sql.extensions", "org.apache.iceberg.spark.extensions.IcebergSparkSessionExtensions");
            builder2.config("spark.sql.catalog.spark_catalog", "org.apache.iceberg.spark.SparkSessionCatalog");
            builder2.config("spark.sql.catalog.spark_catalog.type", "hive");
            builder2.config("spark.sql.catalog.local", "org.apache.iceberg.spark.SparkCatalog");
            builder2.config("spark.sql.catalog.local.type", "hadoop");
            boxedUnit = builder2.config("spark.sql.catalog.local.warehouse", $this.icebergWarehouse());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var1_1;
    }

    public static void sqlBeforeAllTestCases(DataFrameSuiteBaseLike $this) {
        if (SparkSessionProvider$.MODULE$._sparkSession() == null || SparkSessionProvider$.MODULE$._sparkSession().sparkContext().isStopped()) {
            SparkSessionProvider$.MODULE$._sparkSession_$eq($this.builder().getOrCreate());
        }
    }

    public static void assertDataFrameEquals(DataFrameSuiteBaseLike $this, Dataset expected, Dataset result) {
        $this.assertDataFrameApproximateEquals((Dataset<Row>)expected, (Dataset<Row>)result, 0.0);
    }

    public static void assertDataFrameApproximateEquals(DataFrameSuiteBaseLike $this, Dataset expected, Dataset result, double tol) {
        $this.assert(expected.schema(), result.schema(), ClassTag$.MODULE$.apply(StructType.class));
        try {
            expected.rdd().cache();
            result.rdd().cache();
            $this.assert("Length not Equal", BoxesRunTime.boxToLong((long)expected.rdd().count()), BoxesRunTime.boxToLong((long)result.rdd().count()), ClassTag$.MODULE$.Long());
            RDD expectedIndexValue = $this.zipWithIndex(expected.rdd());
            RDD resultIndexValue = $this.zipWithIndex(result.rdd());
            RDD unequalRDD = RDD$.MODULE$.rddToPairRDDFunctions(expectedIndexValue, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Row.class), (Ordering)Ordering.Long$.MODULE$).join(resultIndexValue).filter((Function1)new Serializable($this, tol){
                public static final long serialVersionUID = 0L;
                private final double tol$2;

                public final boolean apply(Tuple2<Object, Tuple2<Row, Row>> x0$3) {
                    Tuple2 tuple2;
                    Tuple2<Object, Tuple2<Row, Row>> tuple22 = x0$3;
                    if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                        Row r2;
                        Row r1 = (Row)tuple2._1();
                        boolean bl = !r1.equals((Object)(r2 = (Row)tuple2._2())) && !DataFrameSuiteBase$.MODULE$.approxEquals(r1, r2, this.tol$2);
                        return bl;
                    }
                    throw new MatchError(tuple22);
                }
                {
                    this.tol$2 = tol$2;
                }
            });
            Tuple2[] unEqualRows = (Tuple2[])unequalRDD.take($this.maxUnequalRowsToShow());
            if (Predef$.MODULE$.refArrayOps((Object[])unEqualRows).nonEmpty()) {
                StructField structField = new StructField("source_dataframe", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructType unequalSchema = StructType$.MODULE$.apply((Seq)Predef$.MODULE$.refArrayOps((Object[])expected.schema().fields()).toList().$colon$colon((Object)structField));
                $this.spark().createDataFrame((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])unEqualRows).flatMap((Function1)new Serializable($this, unequalSchema){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DataFrameSuiteBaseLike $outer;
                    private final StructType unequalSchema$1;

                    public final Seq<Row> apply(Tuple2<Object, Tuple2<Row, Row>> un) {
                        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{this.$outer.tagRow((Row)((Tuple2)un._2())._1(), "expected", this.unequalSchema$1), this.$outer.tagRow((Row)((Tuple2)un._2())._2(), "result", this.unequalSchema$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.unequalSchema$1 = unequalSchema$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)))).toList()).asJava(), unequalSchema).show();
                $this.fail("There are some unequal rows");
            }
            return;
        }
        finally {
            expected.rdd().unpersist(expected.rdd().unpersist$default$1());
            result.rdd().unpersist(result.rdd().unpersist$default$1());
        }
    }

    public static Row tagRow(DataFrameSuiteBaseLike $this, Row row, String tag, StructType schema) {
        Row row2 = row;
        if (row2 instanceof GenericRowWithSchema) {
            GenericRowWithSchema genericRowWithSchema = (GenericRowWithSchema)row2;
            String string = tag;
            GenericRowWithSchema genericRowWithSchema2 = new GenericRowWithSchema((Object[])genericRowWithSchema.toSeq().toList().$colon$colon((Object)string).toArray(ClassTag$.MODULE$.Any()), schema);
            return genericRowWithSchema2;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"row of type ", " is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{row.getClass()})));
    }

    public static void assertDataFrameNoOrderEquals(DataFrameSuiteBaseLike $this, Dataset expected, Dataset result) {
        $this.assert(expected.schema(), result.schema(), ClassTag$.MODULE$.apply(StructType.class));
        $this.assertDataFrameDataEquals((Dataset<Row>)expected, (Dataset<Row>)result);
    }

    public static void assertDataFrameDataEquals(DataFrameSuiteBaseLike $this, Dataset expected, Dataset result) {
        String expectedCol = "assertDataFrameNoOrderEquals_expected";
        String actualCol = "assertDataFrameNoOrderEquals_actual";
        try {
            expected.rdd().cache();
            result.rdd().cache();
            $this.assert("Column size not Equal", BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])expected.columns()).size()), BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])result.columns()).size()), ClassTag$.MODULE$.Int());
            $this.assert("Length not Equal", BoxesRunTime.boxToLong((long)expected.rdd().count()), BoxesRunTime.boxToLong((long)result.rdd().count()), ClassTag$.MODULE$.Long());
            Column[] columns = (Column[])Predef$.MODULE$.refArrayOps((Object[])expected.columns()).map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Column apply(String s) {
                    return functions$.MODULE$.col(s);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
            Dataset expectedElementsCount = expected.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])columns)).agg(functions$.MODULE$.count(functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))).as(expectedCol), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0]));
            Dataset resultElementsCount = result.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])columns)).agg(functions$.MODULE$.count(functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))).as(actualCol), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0]));
            Column joinExprs = (Column)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])expected.columns()).map((Function1)new Serializable($this, expected, result){
                public static final long serialVersionUID = 0L;
                private final Dataset expected$1;
                private final Dataset result$1;

                public final Column apply(String s) {
                    return this.expected$1.col(s).$less$eq$greater((Object)this.result$1.col(s));
                }
                {
                    this.expected$1 = expected$1;
                    this.result$1 = result$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))).reduce((Function2)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Column apply(Column x$5, Column x$6) {
                    return x$5.and(x$6);
                }
            });
            Dataset diff = expectedElementsCount.join(resultElementsCount, joinExprs, "full_outer").filter(functions$.MODULE$.not(functions$.MODULE$.col(expectedCol).$less$eq$greater((Object)functions$.MODULE$.col(actualCol))));
            $this.assertEmpty(diff.take($this.maxUnequalRowsToShow()), ClassTag$.MODULE$.apply(Row.class));
            return;
        }
        finally {
            expected.rdd().unpersist(expected.rdd().unpersist$default$1());
            result.rdd().unpersist(result.rdd().unpersist$default$1());
        }
    }

    public static void assertSmallDataFrameDataEquals(DataFrameSuiteBaseLike $this, Dataset expected, Dataset result) {
        String[] cols = expected.columns();
        $this.assert("Column size not Equal", BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])cols).size()), BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])result.columns()).size()), ClassTag$.MODULE$.Int());
        Set set = Predef$.MODULE$.refArrayOps((Object[])expected.collect()).toSet();
        Set set2 = Predef$.MODULE$.refArrayOps((Object[])result.select((String)Predef$.MODULE$.refArrayOps((Object[])cols).head(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])cols).tail())).collect()).toSet();
        $this.assertTrue(!(set != null ? !set.equals(set2) : set2 != null));
    }

    public static RDD zipWithIndex(DataFrameSuiteBaseLike $this, RDD rdd) {
        return rdd.zipWithIndex().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, U> apply(Tuple2<U, Object> x0$2) {
                Tuple2<U, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    Object row = tuple2._1();
                    long idx = tuple2._2$mcJ$sp();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)idx), row);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public static boolean approxEquals(DataFrameSuiteBaseLike $this, Row r1, Row r2, double tol) {
        return DataFrameSuiteBase$.MODULE$.approxEquals(r1, r2, tol);
    }

    public static void $init$(DataFrameSuiteBaseLike $this) {
        $this.com$holdenkarau$spark$testing$DataFrameSuiteBaseLike$_setter_$maxUnequalRowsToShow_$eq(10);
        $this.com$holdenkarau$spark$testing$DataFrameSuiteBaseLike$_setter_$icebergWarehouse_$eq(new File($this.tempDir(), "iceberg-warehouse").getCanonicalPath());
    }
}

