/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.om;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.fun.MethodInvoker;
import org.beetl.core.fun.ObjectUtil;
import org.beetl.core.misc.PrimitiveArrayUtil;
import org.beetl.core.util.Pair;
import org.jetbrains.annotations.NotNull;

public abstract class AttributeAccess
implements Serializable {
    public abstract Object value(Object var1, Object var2);

    public void setValue(Object o, Object name, Object value) {
        AttributeAccess.updateValue(o, name, value);
    }

    private static void updateValue(Object o, Object k, Object v) {
        if (o instanceof Map) {
            ((Map)o).put(k, v);
        } else if (o instanceof List) {
            try {
                ((List)o).set(((Number)k).intValue(), v);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new BeetlException("ATTRIBUTE_INVALID", ex);
            }
            catch (ClassCastException ex) {
                throw new ClassCastException("\u76ee\u6807\u65e0\u6cd5\u5f3a\u8f6c\u6210 java.util.List\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u5c5e\u6027:" + k);
            }
        } else if (o.getClass().isArray()) {
            try {
                if (o.getClass().getComponentType().isPrimitive()) {
                    PrimitiveArrayUtil.setObject(o, ((Number)k).intValue(), v);
                }
                ((Object[])o)[((Number)k).intValue()] = v;
            }
            catch (ClassCastException ex) {
                throw new ClassCastException("\u7c7b\u578b\u4e3a\u6570\u7ec4\uff0c\u65e0\u6b64\u5c5e\u6027:" + k);
            }
        } else {
            String keyStr = (String)k;
            Class<?> objType = o.getClass();
            MethodInvoker invoker = ObjectUtil.getInvokder(objType, keyStr);
            if (invoker != null) {
                invoker.set(o, v);
            } else {
                throw new BeetlException(ObjectUtil.hasPrivateAttribute(objType, keyStr) ? "ATTRIBUTE_NOT_FOUND_PRIVATE" : "ATTRIBUTE_NOT_FOUND", keyStr);
            }
        }
    }

    @NotNull
    static Pair<Boolean, Integer> checkAndGetIndex(Object attr) {
        if (attr instanceof Integer || attr instanceof Long || attr instanceof Short || attr instanceof Byte || attr instanceof BigDecimal) {
            int index = ((Number)attr).intValue();
            if (index < 0) {
                throw new BeetlException("ARRAY_INDEX_ERROR", "\u7d22\u5f15\u5fc5\u987b\u5927\u4e8e\u6216\u8005\u7b49\u4e8e");
            }
            return new Pair<Boolean, Integer>(true, index);
        }
        return new Pair<Boolean, Object>(false, null);
    }
}

