/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.oracle;

import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.beetl.sql.clazz.NameConversion;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.ConnectionSourceHelper;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLManagerBuilder;
import org.beetl.sql.core.SQLReady;
import org.beetl.sql.core.UnderlinedNameConversion;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.db.Oracle12Style;
import org.beetl.sql.core.page.DefaultPageRequest;
import org.beetl.sql.core.page.PageRequest;
import org.beetl.sql.core.page.PageResult;
import org.beetl.sql.ext.DebugInterceptor;
import org.beetl.sql.oracle.Employee;

public class OracleTest {
    public static void main(String[] args) {
        DataSource dataSource = OracleTest.datasource();
        ConnectionSource source = ConnectionSourceHelper.getSingle((DataSource)dataSource);
        SQLManagerBuilder builder = new SQLManagerBuilder(source);
        builder.setNc((NameConversion)new UnderlinedNameConversion());
        builder.setInters(new Interceptor[]{new DebugInterceptor()});
        builder.setDbStyle((DBStyle)new Oracle12Style());
        SQLManager sqlManager = builder.build();
        String sql = "SELECT e.* FROM scott.EMP e  ";
        PageRequest pageRequest = DefaultPageRequest.of((long)1L, (int)5);
        PageResult list = sqlManager.execute(new SQLReady(sql), Employee.class, pageRequest);
        System.out.println(list);
        sql = "SELECT #{page()} FROM scott.EMP e  ";
        pageRequest = DefaultPageRequest.of((long)1L, (int)10);
        list = sqlManager.executePageQuery(sql, Employee.class, null, pageRequest);
        System.out.println(list);
    }

    public static DataSource datasource() {
        HikariDataSource ds = new HikariDataSource();
        ds.setJdbcUrl("jdbc:oracle:thin:@127.0.0.1:1521:xe");
        ds.setUsername("system");
        ds.setPassword("oracle");
        ds.setDriverClassName("oracle.jdbc.OracleDriver");
        return ds;
    }
}

