/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.test;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;
import org.beetl.sql.clazz.NameConversion;
import org.beetl.sql.core.BaseSQLExecutor;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.ConnectionSourceHelper;
import org.beetl.sql.core.ExecuteContext;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.SQLExecutor;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLManagerBuilder;
import org.beetl.sql.core.UnderlinedNameConversion;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.db.H2Style;
import org.beetl.sql.core.db.MySqlStyle;
import org.beetl.sql.core.engine.SQLParameter;
import org.beetl.sql.ext.DebugInterceptor;
import org.beetl.sql.sample.SampleHelper;
import org.beetl.sql.sample.entity.UserEntity;

public class DbStyleSample {
    public static void main(String[] args) throws Exception {
        DbStyleSample dbStyleSample = new DbStyleSample();
        dbStyleSample.preparedStatement();
    }

    public void preparedStatement() {
        DataSource dataSource = SampleHelper.datasource();
        ConnectionSource source = ConnectionSourceHelper.getSingle((DataSource)dataSource);
        SQLManagerBuilder builder = new SQLManagerBuilder(source);
        builder.setNc((NameConversion)new UnderlinedNameConversion());
        builder.setInters(new Interceptor[]{new DebugInterceptor()});
        builder.setDbStyle((DBStyle)new H2Style());
        SQLManager sqlManager = builder.build();
        sqlManager.all(UserEntity.class);
    }

    public static class H2StylePlus
    extends MySqlStyle {
        public SQLExecutor buildExecutor(ExecuteContext executeContext) {
            return new MyExecutor(executeContext);
        }

        public static class MyExecutor
        extends BaseSQLExecutor {
            public MyExecutor(ExecuteContext executeContext) {
                super(executeContext);
            }

            protected BaseSQLExecutor.ResultSetHolder dbQuery(Connection conn, String sql, List<SQLParameter> jdbcPara) throws SQLException {
                if (this.getExecuteContext().target != UserEntity.class) {
                    return super.dbQuery(conn, sql, jdbcPara);
                }
                PreparedStatement ps = conn.prepareStatement(sql, 1003, 1007);
                ps.setFetchSize(100000);
                this.setPreparedStatementPara(ps, jdbcPara);
                ResultSet rs = ps.executeQuery();
                return new BaseSQLExecutor.ResultSetHolder((Statement)ps, rs);
            }
        }
    }
}

