/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLSource;
import org.beetl.sql.core.SqlId;
import org.beetl.sql.core.loader.AbsolutePathLoader;
import org.beetl.sql.core.loader.SQLFileParser;
import org.beetl.sql.core.loader.SQLLoader;
import org.beetl.sql.sample.SampleHelper;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class SQLLoaderSample {
    public static void main(String[] args) throws Exception {
        SQLLoaderSample loaderSample = new SQLLoaderSample();
        loaderSample.loadFromPath();
    }

    public void loadFromPath() {
        SQLManager sqlManager = SampleHelper.init();
        String root = System.getProperty("user.dir");
        String sqlPath = root + "/sql-samples/plugin/src";
        FileSQLLoader fileSQLLoader = new FileSQLLoader(sqlPath);
        sqlManager.customizedSQLLoader((SQLLoader)fileSQLLoader);
        List all = sqlManager.select(SqlId.of((String)"user.all"), Map.class);
        System.out.println(all.size());
    }

    static class XMLParser
    implements SQLFileParser {
        BufferedReader br;
        String namepspace;
        Iterator<Element> iterator;

        public XMLParser(String modelName, BufferedReader br) {
            this.namepspace = modelName;
            this.br = br;
            SAXBuilder builder = new SAXBuilder();
            Document document = null;
            try {
                document = builder.build((Reader)br);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u89e3\u6790\u51fa\u9519" + modelName);
            }
            Element root = document.getRootElement();
            this.iterator = root.getChildren().iterator();
        }

        public SQLSource next() throws IOException {
            if (!this.iterator.hasNext()) {
                return null;
            }
            Element element = this.iterator.next();
            String id = element.getAttributeValue("id");
            SqlId sqlId = SqlId.of((String)this.namepspace, (String)id);
            String sqlTemplate = element.getText();
            SQLSource sqlSource = new SQLSource();
            sqlSource.setTemplate(sqlTemplate);
            sqlSource.setId(sqlId);
            sqlSource.setLine(0);
            return sqlSource;
        }
    }

    public class FileSQLLoader
    extends AbsolutePathLoader {
        public FileSQLLoader(String path, String charset) {
            super(path, charset);
        }

        public FileSQLLoader(String path) {
            super(path);
        }

        protected URL getFile(String filePath) {
            File file = new File(filePath);
            if (!file.exists()) {
                return null;
            }
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(filePath + " to url");
            }
        }

        protected SQLFileParser getParser(String modelName, BufferedReader br) throws IOException {
            XMLParser parser = new XMLParser(modelName, br);
            return parser;
        }

        protected URL getFilePath(String root, SqlId id) {
            String path = this.getPathBySqlId(id);
            String filePath0 = root + "/" + path + ".xml";
            URL is = this.getFile(filePath0);
            return is;
        }

        public BeetlSQLException getException(SqlId sqlId) {
            String path = this.getPathBySqlId(sqlId);
            String envInfo = path + ".xml sqlLoader:" + (Object)((Object)this);
            envInfo = this.existNamespace(sqlId) ? envInfo + ",\u6587\u4ef6'" + sqlId.getNamespace() + ".xml'\u627e\u5230\uff0c\u4f46\u6ca1\u6709\u5bf9\u5e94\u7684sqlId '" + sqlId.getId() + "'" : envInfo + ",\u672a\u627e\u5230\u5bf9\u5e94\u7684sql\u6587\u4ef6";
            return new BeetlSQLException(2, "\u672a\u80fd\u627e\u5230" + sqlId + "\u5bf9\u5e94\u7684sql,\u641c\u7d22\u8def\u5f84:" + envInfo);
        }
    }
}

