/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.test;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import org.beetl.sql.annotation.entity.Auto;
import org.beetl.sql.annotation.entity.AutoID;
import org.beetl.sql.annotation.entity.Column;
import org.beetl.sql.annotation.entity.Table;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.mapper.BaseMapper;
import org.beetl.sql.mapper.MapperInvoke;
import org.beetl.sql.mapper.annotation.AutoMapper;
import org.beetl.sql.sample.SampleHelper;
import org.beetl.sql.test.annotation.Condition;
import org.beetl.sql.test.annotation.Jackson;
import org.beetl.sql.test.annotation.LoadOne;
import org.beetl.sql.test.annotation.Matcher;
import org.beetl.sql.test.annotation.Tenant;
import org.beetl.sql.test.annotation.TenantContext;

public class PluginAnnotationSample {
    SQLManager sqlManager;

    public PluginAnnotationSample(SQLManager sqlManager) {
        this.sqlManager = sqlManager;
    }

    public static void main(String[] args) throws Exception {
        SQLManager sqlManager = SampleHelper.getSqlManager();
        PluginAnnotationSample plugin = new PluginAnnotationSample(sqlManager);
        plugin.testJacksonAnnotation();
    }

    public void testJacksonAnnotation() {
        UserInfo userInfo = new UserInfo();
        Name name = new Name();
        name.setFirstName("joel");
        name.setLastName("li");
        userInfo.setName(name);
        this.sqlManager.insert((Object)userInfo);
        Integer id = userInfo.getId();
        userInfo = (UserInfo)this.sqlManager.unique(UserInfo.class, (Object)id);
        System.out.println(userInfo.getName());
    }

    public void testMatcherAnnotation() {
        MyMapper mapper = (MyMapper)this.sqlManager.getMapper(MyMapper.class);
        List<UserDetail> list = mapper.query(new Condition().append("name", Condition.Opt.equals), "lijz");
        System.out.println(list.size());
        try {
            mapper.deleteById(1);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public void loadMore() {
        UserDetail userInfo = (UserDetail)this.sqlManager.unique(UserDetail.class, (Object)1);
        System.out.println(userInfo.getDepartmentId());
        System.out.println(userInfo.getDept().getName());
    }

    public void tenant() {
        TenantContext.tenantLocals.set(1);
        String sql = "select * from sys_user where department_id=#{tenantId}";
        List list = this.sqlManager.execute(sql, TenantUser.class, new HashMap());
        System.out.println(list.get(0));
    }

    public static class DeleteCheckByIdAMI
    extends MapperInvoke {
        public Object call(SQLManager sm, Class entityClass, Method m, Object[] args) {
            Long id = ((Number)args[0]).longValue();
            if (id < 100L) {
                throw new IllegalArgumentException("\u4e0d\u5141\u8bb8\u5220\u9664 " + id);
            }
            return sm.deleteById(entityClass, args[0]);
        }
    }

    public static interface MyBaseMapper<T>
    extends BaseMapper {
        @AutoMapper(value=DeleteCheckByIdAMI.class)
        public int deleteById(Object var1);
    }

    public static interface MyMapper
    extends MyBaseMapper<UserInfo> {
        @Matcher
        public List<UserDetail> query(Condition var1, String var2);
    }

    @Table(name="sys_user")
    @Tenant
    public static class TenantUser {
        @Auto
        private Integer id;
        @Column(value="name")
        private String name;

        public Integer getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TenantUser)) {
                return false;
            }
            TenantUser other = (TenantUser)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$id = this.getId();
            Integer other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TenantUser;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "PluginAnnotationSample.TenantUser(id=" + this.getId() + ", name=" + this.getName() + ")";
        }
    }

    @Table(name="department")
    public static class DepartmentInfo {
        @Column(value="id")
        @AutoID
        Integer id;
        String name;

        public Integer getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DepartmentInfo)) {
                return false;
            }
            DepartmentInfo other = (DepartmentInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$id = this.getId();
            Integer other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DepartmentInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "PluginAnnotationSample.DepartmentInfo(id=" + this.getId() + ", name=" + this.getName() + ")";
        }
    }

    @Table(name="sys_user")
    @LoadOne(name="foo")
    public static class UserDetail {
        @Column(value="id")
        @AutoID
        Integer id;
        String name;
        Integer departmentId;
        DepartmentInfo dept;

        public Integer getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Integer getDepartmentId() {
            return this.departmentId;
        }

        public DepartmentInfo getDept() {
            return this.dept;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDepartmentId(Integer departmentId) {
            this.departmentId = departmentId;
        }

        public void setDept(DepartmentInfo dept) {
            this.dept = dept;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserDetail)) {
                return false;
            }
            UserDetail other = (UserDetail)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$id = this.getId();
            Integer other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Integer this$departmentId = this.getDepartmentId();
            Integer other$departmentId = other.getDepartmentId();
            if (this$departmentId == null ? other$departmentId != null : !((Object)this$departmentId).equals(other$departmentId)) {
                return false;
            }
            DepartmentInfo this$dept = this.getDept();
            DepartmentInfo other$dept = other.getDept();
            return !(this$dept == null ? other$dept != null : !((Object)this$dept).equals(other$dept));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UserDetail;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Integer $departmentId = this.getDepartmentId();
            result = result * 59 + ($departmentId == null ? 43 : ((Object)$departmentId).hashCode());
            DepartmentInfo $dept = this.getDept();
            result = result * 59 + ($dept == null ? 43 : ((Object)$dept).hashCode());
            return result;
        }

        public String toString() {
            return "PluginAnnotationSample.UserDetail(id=" + this.getId() + ", name=" + this.getName() + ", departmentId=" + this.getDepartmentId() + ", dept=" + this.getDept() + ")";
        }
    }

    public static class Name {
        String firstName;
        String lastName;

        public String getFirstName() {
            return this.firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Name)) {
                return false;
            }
            Name other = (Name)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$firstName = this.getFirstName();
            String other$firstName = other.getFirstName();
            if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
                return false;
            }
            String this$lastName = this.getLastName();
            String other$lastName = other.getLastName();
            return !(this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Name;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $firstName = this.getFirstName();
            result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
            String $lastName = this.getLastName();
            result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
            return result;
        }

        public String toString() {
            return "PluginAnnotationSample.Name(firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ")";
        }
    }

    @Table(name="sys_user")
    public static class UserInfo {
        @Column(value="id")
        @AutoID
        Integer id;
        @Column(value="name")
        @Jackson
        Name name;

        public Integer getId() {
            return this.id;
        }

        public Name getName() {
            return this.name;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public void setName(Name name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserInfo)) {
                return false;
            }
            UserInfo other = (UserInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$id = this.getId();
            Integer other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Name this$name = this.getName();
            Name other$name = other.getName();
            return !(this$name == null ? other$name != null : !((Object)this$name).equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UserInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Name $name = this.getName();
            result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
            return result;
        }

        public String toString() {
            return "PluginAnnotationSample.UserInfo(id=" + this.getId() + ", name=" + this.getName() + ")";
        }
    }
}

