/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.test.annotation;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLReady;
import org.beetl.sql.mapper.MapperInvoke;
import org.beetl.sql.mapper.builder.MapperExtBuilder;
import org.beetl.sql.test.annotation.Condition;

public class MatcherBuilder
implements MapperExtBuilder {
    public MapperInvoke parse(Class entity, Method m) {
        Class<?> retType = m.getReturnType();
        if (List.class.isAssignableFrom(retType)) {
            Type type = m.getGenericReturnType();
            Class genericType = BeanKit.getCollectionType((Type)type);
            return new MatcherInvoke(false, genericType == null ? entity : genericType);
        }
        return new MatcherInvoke(true, retType);
    }

    public static class MatcherInvoke
    extends MapperInvoke {
        boolean isSingle;
        Class target;

        public MatcherInvoke(boolean isSingle, Class target) {
            this.target = target;
            this.isSingle = isSingle;
        }

        public Object call(SQLManager sm, Class entityClass, Method m, Object[] args) {
            Condition condition = (Condition)args[0];
            String where = condition.toSql();
            String sql = "select * from " + sm.getNc().getTableName(this.target) + " where " + where;
            Object[] jdbcArgs = new Object[args.length - 1];
            System.arraycopy(args, 1, jdbcArgs, 0, jdbcArgs.length);
            List list = sm.execute(new SQLReady(sql, jdbcArgs), this.target);
            if (this.isSingle) {
                return list.isEmpty() ? null : list.get(0);
            }
            return list;
        }
    }
}

