/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.beetl.sql.core.ExecuteContext;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.InterceptorContext;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLReady;
import org.beetl.sql.ext.DebugInterceptor;
import org.beetl.sql.sample.SampleHelper;
import org.beetl.sql.sample.entity.UserEntity;

public class InterceptSample {
    public static void main(String[] args) throws Exception {
        InterceptSample interceptSample = new InterceptSample();
        interceptSample.appendSqlId();
        interceptSample.debug();
    }

    public void appendSqlId() {
        SQLManager sqlManager = SampleHelper.init();
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>(Arrays.asList(sqlManager.getInters()));
        SqlIdAppendInterceptor sqlIdAppendInterceptor = new SqlIdAppendInterceptor();
        interceptors.add(0, sqlIdAppendInterceptor);
        sqlManager.setInters(interceptors.toArray(new Interceptor[0]));
        sqlManager.unique(UserEntity.class, (Object)1);
        sqlManager.execute(new SQLReady("select * from sys_user"), UserEntity.class);
    }

    public void debug() {
        SQLManager sqlManager = SampleHelper.init();
        LogDebugInterceptor logDebugInterceptor = new LogDebugInterceptor();
        sqlManager.setInters(new Interceptor[]{logDebugInterceptor});
        sqlManager.unique(UserEntity.class, (Object)1);
    }

    public static class LogDebugInterceptor
    extends DebugInterceptor {
        Logger logger = Logger.getLogger("simple");

        protected void println(String str) {
            this.logger.log(Level.INFO, str);
        }

        protected void error(String str) {
            this.logger.log(Level.SEVERE, str);
        }
    }

    public static class SqlIdAppendInterceptor
    implements Interceptor {
        public void before(InterceptorContext ctx) {
            ExecuteContext context = ctx.getExecuteContext();
            if (context.sqlId.isSql()) {
                return;
            }
            String jdbcSql = context.sqlResult.jdbcSql;
            String info = context.sqlId.toString();
            context.sqlResult.jdbcSql = jdbcSql = "/*" + info + "*/\n" + jdbcSql;
        }

        public void after(InterceptorContext ctx) {
        }

        public void exception(InterceptorContext ctx, Exception ex) {
        }
    }
}

