/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.test;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TextNode;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.beetl.sql.annotation.entity.Auto;
import org.beetl.sql.annotation.entity.ResultProvider;
import org.beetl.sql.annotation.entity.RowProvider;
import org.beetl.sql.annotation.entity.Table;
import org.beetl.sql.core.ExecuteContext;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLReady;
import org.beetl.sql.core.mapping.BeanProcessor;
import org.beetl.sql.core.mapping.RowMapper;
import org.beetl.sql.core.mapping.type.JavaSqlTypeHandler;
import org.beetl.sql.core.mapping.type.ReadTypeParameter;
import org.beetl.sql.core.mapping.type.WriteTypeParameter;
import org.beetl.sql.sample.SampleHelper;
import org.beetl.sql.test.annotation.XmlMapping;
import org.beetl.sql.test.mappping.SimpleXMLMapping;

public class MappingSample {
    SQLManager sqlManager;

    public MappingSample(SQLManager sqlManager) {
        this.sqlManager = sqlManager;
    }

    public static void main(String[] args) throws Exception {
        SQLManager sqlManager = SampleHelper.getSqlManager();
        MappingSample mappingSample = new MappingSample(sqlManager);
        mappingSample.rowMapper();
        mappingSample.typeHandler4BigInt();
        mappingSample.typeHandler4JacksonNode();
        mappingSample.xmlMapping();
    }

    public void rowMapper() {
        String sql = "select u.*,'[1,2]' col from sys_user u where id=1 ";
        UserVo info = (UserVo)this.sqlManager.execute(new SQLReady(sql), UserVo.class).get(0);
        System.out.println(info.getExtraAttribute());
        info = (UserVo)this.sqlManager.rowMapper(MyRowMapper.class).execute(new SQLReady(sql), UserVo.class).get(0);
        System.out.println(info.getExtraAttribute());
        info = (UserVo)this.sqlManager.execute(new SQLReady(sql), UserVo2.class).get(0);
        System.out.println(info.getExtraAttribute());
    }

    public void typeHandler4BigInt() {
        BigIntTypeHandler bigIntTypeHandler = new BigIntTypeHandler();
        this.sqlManager.getDefaultBeanProcessors().addHandler(BigInteger.class, (JavaSqlTypeHandler)bigIntTypeHandler);
        User2 user = new User2();
        user.setName("lll");
        user.setDepartmentId(new BigInteger("1"));
        this.sqlManager.insert((Object)user);
        Integer id = user.getId();
        User2 dbUser = (User2)this.sqlManager.unique(User2.class, (Object)1);
        System.out.println(id + ":" + dbUser.getDepartmentId());
    }

    public void typeHandler4JacksonNode() {
        JsonNodeTypeHandler typeHandler = new JsonNodeTypeHandler();
        this.sqlManager.getDefaultBeanProcessors().addAcceptType((BeanProcessor.AcceptType)new BeanProcessor.InheritedAcceptType(JsonNode.class, (JavaSqlTypeHandler)typeHandler));
        UserNode user = new UserNode();
        TextNode node = JsonNodeTypeHandler.objectMapper.createObjectNode().textNode("abcefg");
        user.setName((JsonNode)node);
        this.sqlManager.insert((Object)user);
        Integer id = user.getId();
        UserNode dbUser = (UserNode)this.sqlManager.unique(UserNode.class, (Object)1);
        System.out.println(id + ":" + dbUser.getName());
    }

    public void xmlMapping() {
        User3 user = (User3)this.sqlManager.unique(User3.class, (Object)1);
        System.out.println(user.getUserName());
    }

    public static class MyRowMapper
    implements RowMapper<UserVo> {
        public UserVo mapRow(ExecuteContext ctx, Object obj, ResultSet rs, int rowNum, Annotation config) throws SQLException {
            UserVo vo = (UserVo)obj;
            String col = rs.getString("col");
            String[] arrays = col.split(",");
            vo.setExtraAttribute(arrays);
            return vo;
        }
    }

    public static class BigIntTypeHandler
    extends JavaSqlTypeHandler {
        public Object getValue(ReadTypeParameter typePara) throws SQLException {
            BigDecimal decimal = typePara.getRs().getBigDecimal(typePara.getIndex());
            return decimal.toBigInteger();
        }

        public void setParameter(WriteTypeParameter writeTypeParameter, Object obj) throws SQLException {
            BigInteger bigInteger = (BigInteger)obj;
            BigDecimal bigDecimal = new BigDecimal(bigInteger);
            writeTypeParameter.getPs().setBigDecimal(writeTypeParameter.getIndex(), bigDecimal);
        }
    }

    public static class JsonNodeTypeHandler
    extends JavaSqlTypeHandler {
        static ObjectMapper objectMapper = new ObjectMapper();

        public Object getValue(ReadTypeParameter typePara) throws SQLException {
            String str = typePara.getRs().getString(typePara.getIndex());
            JsonNode node = objectMapper.valueToTree((Object)str);
            return node;
        }

        public void setParameter(WriteTypeParameter writeTypeParameter, Object obj) throws SQLException {
            JsonNode node = (JsonNode)obj;
            try {
                String text = objectMapper.writeValueAsString((Object)node);
                writeTypeParameter.getPs().setString(writeTypeParameter.getIndex(), text);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("\u4e0d\u662fjson\u683c\u5f0f");
            }
        }
    }

    @Table(name="sys_user")
    @ResultProvider(value=SimpleXMLMapping.class)
    @XmlMapping(path="user.xml")
    public static class User3 {
        Integer id;
        String userName;
        Integer deptId;

        public Integer getId() {
            return this.id;
        }

        public String getUserName() {
            return this.userName;
        }

        public Integer getDeptId() {
            return this.deptId;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public void setDeptId(Integer deptId) {
            this.deptId = deptId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof User3)) {
                return false;
            }
            User3 other = (User3)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$id = this.getId();
            Integer other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$userName = this.getUserName();
            String other$userName = other.getUserName();
            if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
                return false;
            }
            Integer this$deptId = this.getDeptId();
            Integer other$deptId = other.getDeptId();
            return !(this$deptId == null ? other$deptId != null : !((Object)this$deptId).equals(other$deptId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof User3;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $userName = this.getUserName();
            result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
            Integer $deptId = this.getDeptId();
            result = result * 59 + ($deptId == null ? 43 : ((Object)$deptId).hashCode());
            return result;
        }

        public String toString() {
            return "MappingSample.User3(id=" + this.getId() + ", userName=" + this.getUserName() + ", deptId=" + this.getDeptId() + ")";
        }
    }

    @Table(name="sys_user")
    public static class User2 {
        @Auto
        Integer id;
        String name;
        BigInteger departmentId;

        public Integer getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public BigInteger getDepartmentId() {
            return this.departmentId;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDepartmentId(BigInteger departmentId) {
            this.departmentId = departmentId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof User2)) {
                return false;
            }
            User2 other = (User2)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$id = this.getId();
            Integer other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            BigInteger this$departmentId = this.getDepartmentId();
            BigInteger other$departmentId = other.getDepartmentId();
            return !(this$departmentId == null ? other$departmentId != null : !((Object)this$departmentId).equals(other$departmentId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof User2;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            BigInteger $departmentId = this.getDepartmentId();
            result = result * 59 + ($departmentId == null ? 43 : ((Object)$departmentId).hashCode());
            return result;
        }

        public String toString() {
            return "MappingSample.User2(id=" + this.getId() + ", name=" + this.getName() + ", departmentId=" + this.getDepartmentId() + ")";
        }
    }

    @Table(name="sys_user")
    public static class UserNode {
        @Auto
        Integer id;
        JsonNode name;

        public Integer getId() {
            return this.id;
        }

        public JsonNode getName() {
            return this.name;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public void setName(JsonNode name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserNode)) {
                return false;
            }
            UserNode other = (UserNode)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$id = this.getId();
            Integer other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            JsonNode this$name = this.getName();
            JsonNode other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UserNode;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            JsonNode $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "MappingSample.UserNode(id=" + this.getId() + ", name=" + this.getName() + ")";
        }
    }

    @RowProvider(value=MyRowMapper.class)
    public static class UserVo2
    extends UserVo {
        @Override
        public String toString() {
            return "MappingSample.UserVo2()";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserVo2)) {
                return false;
            }
            UserVo2 other = (UserVo2)o;
            return other.canEqual(this);
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof UserVo2;
        }

        @Override
        public int hashCode() {
            int result = 1;
            return result;
        }
    }

    public static class UserVo {
        Integer id;
        String name;
        String[] extraAttribute;

        public Integer getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String[] getExtraAttribute() {
            return this.extraAttribute;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setExtraAttribute(String[] extraAttribute) {
            this.extraAttribute = extraAttribute;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserVo)) {
                return false;
            }
            UserVo other = (UserVo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$id = this.getId();
            Integer other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            return Arrays.deepEquals(this.getExtraAttribute(), other.getExtraAttribute());
        }

        protected boolean canEqual(Object other) {
            return other instanceof UserVo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getExtraAttribute());
            return result;
        }

        public String toString() {
            return "MappingSample.UserVo(id=" + this.getId() + ", name=" + this.getName() + ", extraAttribute=" + Arrays.deepToString(this.getExtraAttribute()) + ")";
        }
    }
}

