package org.beetl.sql.core;

import org.beetl.sql.clazz.SQLType;
import org.beetl.sql.core.loader.MarkdownClasspathLoader.SQLFileVersion;

public class SQLSource {

	public SqlId id;
	public String template;
	/**
	 * 如果在sql文件里的实际行数，用于定位模板
	 */
	public int line = 0;
	/**
	 * 内置的sql语句有确定的SQLType
	 */
	public SQLType sqlType = SQLType.UNKNOWN;
	/**
	 * 内置的sql语句总是true，从sql文件里读出的总是false
	 */
	public boolean isAutoGenerated = false;

	SQLFileVersion version = new SQLFileVersion();

	public SQLSource() {
	}

	public SQLSource(SqlId id, String template) {
		this.id = id;
		this.template = template;
	}

	public static SQLSource emptySource(){
		SQLSource sqlSource = new SQLSource();
		sqlSource.template="empty";
		return sqlSource;
	}

	public SQLFileVersion getVersion() {
		return version;
	}

	public void setVersion(SQLFileVersion version) {
		this.version = version;
	}

	public String getTemplate() {
		return template;
	}

	public void setTemplate(String template) {
		this.template = template;
	}

	
	public SqlId getId() {
		return id;
	}

	public void setId(SqlId id) {
		this.id = id;
	}

	public int getLine() {
		return line;
	}

	public void setLine(int line) {
		this.line = line;
	}

	public SQLType getSqlType() {
		return sqlType;
	}

	public void setSqlType(SQLType sqlType) {
		this.sqlType = sqlType;
	}

	public boolean isAutoGenerated() {
		return isAutoGenerated;
	}

	public void setAutoGenerated(boolean autoGenerated) {
		isAutoGenerated = autoGenerated;
	}
}
