/*
 * Decompiled with CFR 0.152.
 */
package com.beetl.sql.dynamic;

import com.beetl.sql.dynamic.BaseEntity;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;
import org.beetl.core.GroupTemplate;
import org.beetl.core.misc.ByteClassLoader;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.gen.BaseProject;
import org.beetl.sql.gen.SourceConfig;
import org.beetl.sql.gen.simple.EntitySourceBuilder;
import org.beetl.sql.gen.simple.StringOnlyProject;

public class DynamicEntityLoader<T> {
    protected SQLManager sqlManager;
    protected Map<String, Class<? extends T>> cache = new ConcurrentHashMap<String, Class<? extends T>>();
    private final Pattern CLASS_PATTERN = Pattern.compile("class\\s+([$_a-zA-Z][$_a-zA-Z0-9]*)\\s*");
    private static Map<String, JavaFileObject> fileObjectMap = new ConcurrentHashMap<String, JavaFileObject>();
    protected String pkg;
    protected Class<T> baseClass;
    protected ByteClassLoader loader = null;

    public DynamicEntityLoader(SQLManager sqlManager) {
        this(sqlManager, "com.test001", BaseEntity.class);
    }

    public DynamicEntityLoader(SQLManager sqlManager, String pkg, Class<T> clazz) {
        this.sqlManager = sqlManager;
        this.pkg = pkg;
        this.baseClass = clazz;
        ClassLoader defaultClassLoader = Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : GroupTemplate.class.getClassLoader();
        this.loader = new ByteClassLoader(defaultClassLoader);
    }

    public DynamicEntityLoader(SQLManager sqlManager, String pkg, Class<T> clazz, ClassLoader classLoader) {
        this.sqlManager = sqlManager;
        this.pkg = pkg;
        this.baseClass = clazz;
        this.loader = new ByteClassLoader(classLoader);
    }

    public Class<? extends T> getDynamicEntity(String table) {
        return this.getDynamicEntity(table, this.baseClass);
    }

    public Class<? extends T> getDynamicEntity(String table, Class<T> clazz) {
        Class c = this.cache.get(table);
        if (c != null) {
            return c;
        }
        c = this.cache.computeIfAbsent(table, s -> {
            Class<T> newCLass = this.compile((String)s, clazz.getName());
            return newCLass;
        });
        return c;
    }

    protected Class<? extends T> compile(String table, String baseObject) {
        ArrayList<EntitySourceBuilder> sourceBuilder = new ArrayList<EntitySourceBuilder>();
        EntitySourceBuilder entityBuilder = new EntitySourceBuilder();
        sourceBuilder.add(entityBuilder);
        SourceConfig config = new SourceConfig(this.sqlManager, sourceBuilder);
        config.setEntityParentClass(baseObject);
        StringOnlyProject project = new StringOnlyProject(){

            public String getBasePackage(String sourceBuilderName) {
                return DynamicEntityLoader.this.pkg + "." + sourceBuilderName;
            }
        };
        String entityPkg = this.pkg + ".entity";
        config.gen(table, (BaseProject)project);
        String javaCode = project.getContent();
        Class<T> c = this.doCompile(entityPkg, javaCode);
        return c;
    }

    protected Class<? extends T> doCompile(String pkg, String javaCode) {
        Matcher matcher = this.CLASS_PATTERN.matcher(javaCode);
        if (!matcher.find()) {
            throw new IllegalArgumentException("No valid class");
        }
        String className = matcher.group(1);
        byte[] classByte = this.getByte(pkg, className, javaCode);
        Class c = this.loader.defineClass(pkg + "." + className, classByte);
        return c;
    }

    protected byte[] getByte(String pkg, String className, String javaCode) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector compileCollector = new DiagnosticCollector();
        TmpJavaFileManager javaFileManager = new TmpJavaFileManager(compiler.getStandardFileManager(compileCollector, null, null));
        TmpJavaFileObject sourceJavaFileObject = new TmpJavaFileObject(className, javaCode);
        Boolean result = compiler.getTask(null, javaFileManager, compileCollector, null, null, Arrays.asList(sourceJavaFileObject)).call();
        if (!result.booleanValue()) {
            throw new IllegalArgumentException("compile error " + compileCollector.getDiagnostics());
        }
        JavaFileObject bytesJavaFileObject = fileObjectMap.get(pkg + "." + className);
        byte[] bs = ((TmpJavaFileObject)bytesJavaFileObject).getCompiledBytes();
        return bs;
    }

    public static class TmpJavaFileObject
    extends SimpleJavaFileObject {
        private String source;
        private ByteArrayOutputStream outputStream;

        public TmpJavaFileObject(String name, String source) {
            super(URI.create("String:///" + name + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.source = source;
        }

        public TmpJavaFileObject(String name, JavaFileObject.Kind kind) {
            super(URI.create("String:///" + name + JavaFileObject.Kind.SOURCE.extension), kind);
            this.source = null;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            if (this.source == null) {
                throw new IllegalArgumentException("source == null");
            }
            return this.source;
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            this.outputStream = new ByteArrayOutputStream();
            return this.outputStream;
        }

        public byte[] getCompiledBytes() {
            return this.outputStream.toByteArray();
        }
    }

    public static class TmpJavaFileManager
    extends ForwardingJavaFileManager<JavaFileManager> {
        protected TmpJavaFileManager(JavaFileManager fileManager) {
            super(fileManager);
        }

        @Override
        public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
            JavaFileObject javaFileObject = (JavaFileObject)fileObjectMap.get(className);
            if (javaFileObject == null) {
                return super.getJavaFileForInput(location, className, kind);
            }
            return javaFileObject;
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            TmpJavaFileObject javaFileObject = new TmpJavaFileObject(className, kind);
            fileObjectMap.put(className, javaFileObject);
            return javaFileObject;
        }
    }
}

