/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.mapper.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.core.ExecuteContext;
import org.beetl.sql.core.page.PageRequest;
import org.beetl.sql.mapper.annotation.Param;
import org.beetl.sql.mapper.annotation.Root;
import org.beetl.sql.mapper.builder.MethodParam;
import org.beetl.sql.mapper.builder.MethodParamsHolder;

public class ParameterParser {
    Method method;
    MethodParamsHolder holder = null;

    public ParameterParser(Method method) {
        this.method = method;
        this.holder = this.parse();
    }

    public MethodParamsHolder getHolder() {
        return this.holder;
    }

    protected MethodParamsHolder parse() {
        MethodParamsHolder holder = new MethodParamsHolder();
        ArrayList<MethodParam> paras = new ArrayList<MethodParam>();
        Parameter[] paraConfig = this.method.getParameters();
        Class<?>[] parasType = this.method.getParameterTypes();
        Annotation[][] anns = this.method.getParameterAnnotations();
        for (int i = 0; i < paraConfig.length; ++i) {
            MethodParam para = new MethodParam();
            Param paramAnno = this.getParamAnnotation(anns[i]);
            boolean isRoot = this.isRoot(anns[i]);
            if (paramAnno != null) {
                para.setName(paramAnno.value());
            } else {
                para.setName(paraConfig[i].getName());
            }
            if (PageRequest.class.isAssignableFrom(parasType[i])) {
                holder.setPageRequestIndex(i);
            }
            if (isRoot) {
                para.setRoot(true);
                holder.setRootParamIndex(i);
            }
            para.setIndex(i);
            paras.add(para);
        }
        if (parasType.length == 1 && !BeanKit.isBaseDataType(parasType[0]) && !PageRequest.class.isAssignableFrom(parasType[0])) {
            holder.setRootParamIndex(0);
            ((MethodParam)paras.get(0)).setRoot(true);
        }
        holder.setParas(paras);
        return holder;
    }

    protected boolean isRoot(Annotation[] anns) {
        boolean hasRoot = false;
        boolean hasParam = false;
        for (Annotation an : anns) {
            if (an instanceof Root) {
                hasRoot = true;
                continue;
            }
            if (!(an instanceof Param)) continue;
            hasParam = true;
        }
        if (hasParam) {
            return false;
        }
        return hasRoot;
    }

    protected Param getParamAnnotation(Annotation[] anns) {
        for (Annotation an : anns) {
            if (!(an instanceof Param)) continue;
            return (Param)an;
        }
        return null;
    }

    public static Object wrapParasForSQLManager(Object[] paras, MethodParamsHolder holder) {
        if (paras.length == 0) {
            return new HashMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (MethodParam param : holder.getParas()) {
            map.put(param.getParamName(), paras[param.getIndex()]);
            if (!param.isRoot()) continue;
            map.put(ExecuteContext.ROOT_PARAM, paras[param.getIndex()]);
        }
        return map;
    }
}

