/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.mapper.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.beetl.sql.core.page.PageResult;
import org.beetl.sql.mapper.MapperInvoke;
import org.beetl.sql.mapper.annotation.Select;
import org.beetl.sql.mapper.annotation.SqlProvider;
import org.beetl.sql.mapper.annotation.SqlTemplateProvider;
import org.beetl.sql.mapper.builder.MapperExtBuilder;
import org.beetl.sql.mapper.builder.MapperMethodParser;
import org.beetl.sql.mapper.builder.MethodParamsHolder;
import org.beetl.sql.mapper.builder.ParameterParser;
import org.beetl.sql.mapper.builder.ReturnTypeParser;
import org.beetl.sql.mapper.provider.BaseSqlPMI;
import org.beetl.sql.mapper.provider.BaseSqlTemplatePMI;
import org.beetl.sql.mapper.provider.SqlPMI;
import org.beetl.sql.mapper.provider.SqlPagePMI;
import org.beetl.sql.mapper.provider.SqlTemplatePMI;
import org.beetl.sql.mapper.provider.SqlTemplatePagePMI;

public class ProviderMapperExtBuilder
implements MapperExtBuilder {
    @Override
    public MapperInvoke parse(Class entity, Method m) {
        boolean pageResultRequired;
        Class targetType;
        SqlProvider sqlProvider = m.getAnnotation(SqlProvider.class);
        ReturnTypeParser returnTypeParser = new ReturnTypeParser(m, entity);
        Annotation annotation = MapperMethodParser.getSqlType(m);
        ParameterParser parameterParser = new ParameterParser(m);
        MethodParamsHolder paramsHolder = parameterParser.getHolder();
        if (sqlProvider != null) {
            BaseSqlPMI mapperInvoke = null;
            if (paramsHolder.hasPageRequest()) {
                Class targetType2 = returnTypeParser.getPageResultType();
                boolean pageResultRequired2 = false;
                if (PageResult.class.isAssignableFrom(returnTypeParser.getType())) {
                    pageResultRequired2 = true;
                }
                mapperInvoke = new SqlPagePMI(sqlProvider, targetType2, pageResultRequired2, paramsHolder);
            } else {
                boolean isSingle = !returnTypeParser.isCollection();
                boolean isSelect = annotation == null || annotation instanceof Select;
                Class targetType3 = isSelect ? returnTypeParser.getCollectionType() : returnTypeParser.getType();
                mapperInvoke = new SqlPMI(sqlProvider, targetType3, isSelect, isSelect);
            }
            return mapperInvoke;
        }
        SqlTemplateProvider templateProvider = m.getAnnotation(SqlTemplateProvider.class);
        BaseSqlTemplatePMI mapperInvoke = null;
        if (paramsHolder.hasPageRequest()) {
            targetType = returnTypeParser.getPageResultType();
            pageResultRequired = false;
            if (PageResult.class.isAssignableFrom(returnTypeParser.getType())) {
                pageResultRequired = true;
            }
        } else {
            boolean isSelect = annotation == null || annotation instanceof Select;
            boolean isSingle = !returnTypeParser.isCollection();
            Class targetType4 = isSelect ? returnTypeParser.getCollectionType() : returnTypeParser.getType();
            mapperInvoke = new SqlTemplatePMI(templateProvider, targetType4, paramsHolder, isSelect, isSingle);
            return mapperInvoke;
        }
        mapperInvoke = new SqlTemplatePagePMI(templateProvider, targetType, pageResultRequired, paramsHolder);
        return mapperInvoke;
    }
}

