/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.mapper.springdata;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.core.query.Query;
import org.beetl.sql.mapper.MapperInvoke;
import org.beetl.sql.mapper.builder.MapperExtBuilder;
import org.beetl.sql.mapper.builder.MethodParamsHolder;
import org.beetl.sql.mapper.builder.ParameterParser;
import org.beetl.sql.mapper.builder.ReturnTypeParser;
import org.beetl.sql.mapper.springdata.SpringDataSelectMI;

public class SpringDataBuilder
implements MapperExtBuilder {
    static Map<String, Class> conditionMap = new HashMap<String, Class>();
    static And and;
    static Or or;
    static final List<String> reserved;

    public Condition getConditionByWord(String word) {
        if (word.equals("And")) {
            return and;
        }
        if (word.equals("Or")) {
            return or;
        }
        try {
            return (Condition)conditionMap.get(word).newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public MapperInvoke parse(Class entity, Method m) {
        String method = m.getName();
        List<String> list = SpringDataBuilder.splitStr(method);
        String query = list.get(0);
        if (!(query.equals("queryBy") || query.equals("getBy") || query.equals("findBy"))) {
            throw new BeetlSQLException(10, "\u65b9\u6cd5\u540d\u4e0d\u7b26\u5408 " + m.getName());
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        String lastAttr = null;
        Condition lastCondition = null;
        for (int i = 1; i < list.size(); ++i) {
            String word = list.get(i);
            if (reserved.contains(word)) {
                if (word.equals("OrderBy")) {
                    OrderBy orderBy = new OrderBy();
                    String attr = list.get(i + 1);
                    orderBy.setAttr(attr);
                    if (list.size() > i + 2) {
                        String sortStr = list.get(i + 2);
                        orderBy.asc = sortStr.equals("Asc");
                    }
                    this.addDefaultEquals(conditions, lastAttr, lastCondition);
                    lastCondition = null;
                    lastAttr = null;
                    conditions.add(orderBy);
                    break;
                }
                if (word.equals("And") || word.equals("Or")) {
                    this.addDefaultEquals(conditions, lastAttr, lastCondition);
                    lastCondition = null;
                    lastAttr = null;
                    conditions.add(this.getConditionByWord(word));
                    continue;
                }
                lastCondition = this.getConditionByWord(word);
                if (lastAttr == null) {
                    throw new BeetlSQLException(10, "\u65b9\u6cd5\u540d\u4e0d\u7b26\u5408 " + m.getName());
                }
                lastCondition.setAttr(lastAttr);
                conditions.add(lastCondition);
                lastCondition = null;
                lastAttr = null;
                continue;
            }
            lastAttr = word;
        }
        this.addDefaultEquals(conditions, lastAttr, lastCondition);
        ParameterParser parameterParser = new ParameterParser(m);
        MethodParamsHolder paramsHolder = parameterParser.getHolder();
        ReturnTypeParser returnTypeParser = new ReturnTypeParser(m, entity);
        boolean isSingle = true;
        if (returnTypeParser.isCollection()) {
            isSingle = false;
        }
        SpringDataSelectMI springData = new SpringDataSelectMI(conditions, paramsHolder, isSingle);
        return springData;
    }

    protected void addDefaultEquals(List<Condition> conditions, String lastAttr, Condition lastCondition) {
        if (lastAttr != null && lastCondition == null) {
            Condition equals = this.getConditionByWord("Equals");
            equals.setAttr(lastAttr);
            conditions.add(equals);
        }
    }

    private static List<String> splitStr(String str) {
        int i;
        ArrayList<String> result = new ArrayList<String>();
        TreeMap<Integer, String> indexContentMap = new TreeMap<Integer, String>();
        StringBuilder sb = new StringBuilder(str);
        for (i = 0; i < reserved.size(); ++i) {
            int index;
            String key = reserved.get(i);
            while ((index = sb.indexOf(key)) >= 0) {
                indexContentMap.put(index, key);
                for (int j = 0; j < key.length(); ++j) {
                    sb.setCharAt(index + j, '\u0000');
                }
            }
        }
        for (i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) == '\u0000') continue;
            int startIndex = i;
            while (i < sb.length() && sb.charAt(i) != '\u0000') {
                ++i;
            }
            indexContentMap.put(startIndex, sb.substring(startIndex, i));
        }
        for (Map.Entry entry : indexContentMap.entrySet()) {
            result.add((String)entry.getValue());
        }
        return result;
    }

    public static void main(String[] args) {
        String method = "queryByNameAndDepartmentIdOrderByIdAsc";
        List<String> list = SpringDataBuilder.splitStr(method);
        System.out.println(list);
    }

    static {
        conditionMap.put("After", After.class);
        conditionMap.put("GreaterThan", After.class);
        conditionMap.put("GreaterThanEqual", AfterEqual.class);
        conditionMap.put("Before", Before.class);
        conditionMap.put("LessThan", Before.class);
        conditionMap.put("LessThanEqual", BeforeEquals.class);
        conditionMap.put("Between", Between.class);
        conditionMap.put("NotBetween", NotBetween.class);
        conditionMap.put("In", In.class);
        conditionMap.put("NotIn", NotIn.class);
        conditionMap.put("IsNull", IsNull.class);
        conditionMap.put("Null", IsNull.class);
        conditionMap.put("IsNotNull", IsNotNull.class);
        conditionMap.put("NotNull", IsNotNull.class);
        conditionMap.put("Like", Like.class);
        conditionMap.put("StartingWith", Like.class);
        conditionMap.put("EndingWith", Like.class);
        conditionMap.put("NotLike", NotLike.class);
        conditionMap.put("IsNotLike", NotLike.class);
        conditionMap.put("Containing", Containing.class);
        conditionMap.put("NotContaining", NotContaining.class);
        conditionMap.put("Not", NotEquals.class);
        conditionMap.put("And", And.class);
        conditionMap.put("Or", Or.class);
        conditionMap.put("Equals", Equals.class);
        and = new And();
        or = new Or();
        reserved = new ArrayList<String>();
        reserved.add("queryBy");
        reserved.add("findBy");
        reserved.add("getBy");
        reserved.add("After");
        reserved.add("OrderBy");
        reserved.add("GreaterThan");
        reserved.add("GreaterThanEqual");
        reserved.add("Before");
        reserved.add("LessThan");
        reserved.add("LessThanEqual");
        reserved.add("Between");
        reserved.add("NotBetween");
        reserved.add("In");
        reserved.add("NotIn");
        reserved.add("IsNull");
        reserved.add("Null");
        reserved.add("IsNotNull");
        reserved.add("NotNull");
        reserved.add("Like");
        reserved.add("StartingWith");
        reserved.add("EndingWith");
        reserved.add("NotLike");
        reserved.add("IsNotLike");
        reserved.add("Containing");
        reserved.add("NotContaining");
        reserved.add("Not");
        reserved.add("And");
        reserved.add("Or");
        reserved.add("Asc");
        reserved.add("Desc");
    }

    static class OrderBy
    extends Condition {
        boolean asc;

        @Override
        public void run(Context ctx) {
            String col = this.getCol(ctx.target, ctx.query);
            if (this.asc) {
                ctx.query.asc(col);
            } else {
                ctx.query.desc(col);
            }
            ctx.movePara();
        }
    }

    static class NotContaining
    extends Condition {
        NotContaining() {
        }

        @Override
        public void run(Context ctx) {
            String col = this.getCol(ctx.target, ctx.query);
            if (ctx.isAnd) {
                ctx.query.andNotLike(col, (Object)("%" + ctx.args[ctx.begin] + "%"));
            } else {
                ctx.query.orNotLike(col, (Object)("%" + ctx.args[ctx.begin] + "%"));
            }
            ctx.movePara();
        }
    }

    static class Containing
    extends Condition {
        Containing() {
        }

        @Override
        public void run(Context ctx) {
            String col = this.getCol(ctx.target, ctx.query);
            if (ctx.isAnd) {
                ctx.query.andLike(col, (Object)("%" + ctx.args[ctx.begin] + "%"));
            } else {
                ctx.query.orLike(col, (Object)("%" + ctx.args[ctx.begin] + "%"));
            }
            ctx.movePara();
        }
    }

    static class NotLike
    extends Condition {
        NotLike() {
        }

        @Override
        public void run(Context ctx) {
            String col = this.getCol(ctx.target, ctx.query);
            if (ctx.isAnd) {
                ctx.query.andNotLike(col, ctx.args[ctx.begin]);
            } else {
                ctx.query.orNotLike(col, ctx.args[ctx.begin]);
            }
            ctx.movePara();
        }
    }

    static class Like
    extends Condition {
        Like() {
        }

        @Override
        public void run(Context ctx) {
            String col = this.getCol(ctx.target, ctx.query);
            if (ctx.isAnd) {
                ctx.query.andLike(col, ctx.args[ctx.begin]);
            } else {
                ctx.query.orLike(col, ctx.args[ctx.begin]);
            }
            ctx.movePara();
        }
    }

    static class IsNotNull
    extends Condition {
        IsNotNull() {
        }

        @Override
        public void run(Context ctx) {
            String col = this.getCol(ctx.target, ctx.query);
            if (ctx.isAnd) {
                ctx.query.andIsNotNull(col);
            } else {
                ctx.query.orIsNotNull(col);
            }
        }
    }

    static class IsNull
    extends Condition {
        IsNull() {
        }

        @Override
        public void run(Context ctx) {
            String col = this.getCol(ctx.target, ctx.query);
            if (ctx.isAnd) {
                ctx.query.andIsNull(col);
            } else {
                ctx.query.orIsNull(col);
            }
        }
    }

    static class NotBetween
    extends Condition {
        NotBetween() {
        }

        @Override
        public void run(Context ctx) {
            String col = this.getCol(ctx.target, ctx.query);
            if (ctx.isAnd) {
                ctx.query.andNotBetween(col, ctx.args[ctx.begin], ctx.args[ctx.begin + 1]);
            } else {
                ctx.query.orNotBetween(col, ctx.args[ctx.begin], ctx.args[ctx.begin + 1]);
            }
            ctx.movePara(2);
        }
    }

    static class NotIn
    extends Condition {
        NotIn() {
        }

        @Override
        public void run(Context ctx) {
            String col = this.getCol(ctx.target, ctx.query);
            if (ctx.isAnd) {
                ctx.query.andNotIn(col, (Collection)ctx.args[ctx.begin]);
            } else {
                ctx.query.orNotIn(col, (Collection)ctx.args[ctx.begin]);
            }
            ctx.movePara();
        }
    }

    static class In
    extends Condition {
        In() {
        }

        @Override
        public void run(Context ctx) {
            String col = this.getCol(ctx.target, ctx.query);
            if (ctx.isAnd) {
                ctx.query.andIn(col, (Collection)ctx.args[ctx.begin]);
            } else {
                ctx.query.orIn(col, (Collection)ctx.args[ctx.begin]);
            }
            ctx.movePara();
        }
    }

    static class Between
    extends Condition {
        Between() {
        }

        @Override
        public void run(Context ctx) {
            String col = this.getCol(ctx.target, ctx.query);
            if (ctx.isAnd) {
                ctx.query.andBetween(col, ctx.args[ctx.begin], ctx.args[ctx.begin + 1]);
            } else {
                ctx.query.orBetween(col, ctx.args[ctx.begin], ctx.args[ctx.begin + 1]);
            }
            ctx.movePara(2);
        }
    }

    static class NotEquals
    extends Condition {
        NotEquals() {
        }

        @Override
        public void run(Context ctx) {
            String col = this.getCol(ctx.target, ctx.query);
            if (ctx.isAnd) {
                ctx.query.andNotEq(col, ctx.args[ctx.begin]);
            } else {
                ctx.query.orNotEq(col, ctx.args[ctx.begin]);
            }
            ctx.movePara();
        }
    }

    static class Equals
    extends Condition {
        Equals() {
        }

        @Override
        public void run(Context ctx) {
            String col = this.getCol(ctx.target, ctx.query);
            if (ctx.isAnd) {
                ctx.query.andEq(col, ctx.args[ctx.begin]);
            } else {
                ctx.query.orEq(col, ctx.args[ctx.begin]);
            }
            ctx.movePara();
        }
    }

    static class BeforeEquals
    extends Condition {
        BeforeEquals() {
        }

        @Override
        public void run(Context ctx) {
            String col = this.getCol(ctx.target, ctx.query);
            if (ctx.isAnd) {
                ctx.query.andLessEq(col, ctx.args[ctx.begin]);
            } else {
                ctx.query.orLessEq(col, ctx.args[ctx.begin]);
            }
            ctx.movePara();
        }
    }

    static class Before
    extends Condition {
        Before() {
        }

        @Override
        public void run(Context ctx) {
            String col = this.getCol(ctx.target, ctx.query);
            if (ctx.isAnd) {
                ctx.query.andLess(col, ctx.args[ctx.begin]);
            } else {
                ctx.query.orLess(col, ctx.args[ctx.begin]);
            }
            ctx.movePara();
        }
    }

    static class AfterEqual
    extends Condition {
        AfterEqual() {
        }

        @Override
        public void run(Context ctx) {
            String col = this.getCol(ctx.target, ctx.query);
            if (ctx.isAnd) {
                ctx.query.andGreatEq(col, ctx.args[ctx.begin]);
            } else {
                ctx.query.orGreatEq(col, ctx.args[ctx.begin]);
            }
            ctx.movePara();
        }
    }

    static class After
    extends Condition {
        After() {
        }

        @Override
        public void run(Context ctx) {
            String col = this.getCol(ctx.target, ctx.query);
            if (ctx.isAnd) {
                ctx.query.andGreat(col, ctx.args[ctx.begin]);
            } else {
                ctx.query.orGreat(col, ctx.args[ctx.begin]);
            }
            ctx.movePara();
        }
    }

    static class Or
    extends Condition {
        Or() {
        }

        @Override
        public void run(Context ctx) {
            ctx.isAnd = false;
        }
    }

    static class And
    extends Condition {
        And() {
        }

        @Override
        public void run(Context ctx) {
            ctx.isAnd = true;
        }
    }

    static abstract class Condition
    implements KeyWord {
        String attr;

        Condition() {
        }

        public void setAttr(String attr) {
            this.attr = attr;
        }

        public String getCol(Class cls, Query query) {
            return query.sqlManager.getNc().getColName(cls, this.attr);
        }
    }

    static interface KeyWord {
        public void run(Context var1);
    }

    static class Context {
        int begin;
        Query query;
        Class target;
        Object[] args;
        boolean isAnd = true;
        MethodParamsHolder holder;

        Context() {
        }

        public void movePara() {
            ++this.begin;
        }

        public void movePara(int i) {
            this.begin += i;
        }
    }
}

